/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import jm.JMC;
import jm.midi.MidiUtil;
import jm.midi.SMF;
import jm.midi.Track;
import jm.midi.event.CChange;
import jm.midi.event.EndTrack;
import jm.midi.event.Event;
import jm.midi.event.KeySig;
import jm.midi.event.NoteOn;
import jm.midi.event.PChange;
import jm.midi.event.TempoEvent;
import jm.midi.event.TimeSig;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public final class MidiParser
implements JMC {
    private static double tickRemainder = 0.0;

    public static void SMFToScore(Score score, SMF smf) {
        System.out.println("Convert SMF to JM");
        Enumeration enume = smf.getTrackList().elements();
        while (enume.hasMoreElements()) {
            Part part = new Part();
            Track smfTrack = (Track)enume.nextElement();
            Vector evtList = smfTrack.getEvtList();
            Vector phrVct = new Vector();
            MidiParser.sortEvents(score, evtList, phrVct, smf, part);
            int i = 0;
            while (i < phrVct.size()) {
                part.addPhrase((Phrase)phrVct.elementAt(i));
                ++i;
            }
            score.addPart(part);
            score.clean();
        }
    }

    private static void sortEvents(Score score, Vector evtList, Vector phrVct, SMF smf, Part part) {
        double startTime = 0.0;
        double[] currentLength = new double[100];
        Note[] curNote = new Note[100];
        boolean numOfPhrases = false;
        double oldTime = 0.0;
        int phrIndex = 0;
        int i = 0;
        while (i < evtList.size()) {
            Event evt = (Event)evtList.elementAt(i);
            startTime += (double)evt.getTime() / (double)smf.getPPQN();
            if (evt.getID() == 7) {
                PChange pchg = (PChange)evt;
                part.setInstrument(pchg.getValue());
            } else if (evt.getID() == 16) {
                TempoEvent t = (TempoEvent)evt;
                score.setTempo(t.getTempo());
            } else if (evt.getID() == 5) {
                NoteOn noteOn = (NoteOn)evt;
                part.setChannel(noteOn.getMidiChannel());
                short pitch = noteOn.getPitch();
                short dynamic = noteOn.getVelocity();
                short midiChannel = noteOn.getMidiChannel();
                if (dynamic > 0) {
                    MidiParser.noteOn(phrIndex, curNote, smf, i, currentLength, startTime, phrVct, midiChannel, pitch, dynamic, evtList);
                }
            }
            ++i;
        }
    }

    private static void noteOn(int phrIndex, Note[] curNote, SMF smf, int i, double[] currentLength, double startTime, Vector phrVct, short midiChannel, short pitch, int dynamic, Vector evtList) {
        phrIndex = -1;
        int p = 0;
        while (p < phrVct.size()) {
            if (currentLength[p] <= startTime + 0.08) {
                phrIndex = p;
                break;
            }
            ++p;
        }
        if (phrIndex == -1) {
            phrIndex = phrVct.size();
            phrVct.addElement(new Phrase(startTime));
            currentLength[phrIndex] = startTime;
        }
        if (startTime > currentLength[phrIndex] && curNote[phrIndex] != null) {
            double newTime = startTime - currentLength[phrIndex];
            if (newTime < 0.25) {
                double length = curNote[phrIndex].getRhythmValue();
                curNote[phrIndex].setRhythmValue(length + newTime);
            } else {
                Note restNote = new Note(Integer.MIN_VALUE, newTime, 0);
                restNote.setPan(midiChannel);
                restNote.setDuration(newTime);
                restNote.setOffset(0.0);
                ((Phrase)phrVct.elementAt(phrIndex)).addNote(restNote);
            }
            int n = phrIndex;
            currentLength[n] = currentLength[n] + newTime;
        }
        double time = MidiUtil.getEndEvt(pitch, evtList, i) / (double)smf.getPPQN();
        Note tempNote = new Note(pitch, time, dynamic);
        tempNote.setDuration(time);
        curNote[phrIndex] = tempNote;
        ((Phrase)phrVct.elementAt(phrIndex)).addNote(curNote[phrIndex]);
        int n = phrIndex;
        currentLength[n] = currentLength[n] + curNote[phrIndex].getRhythmValue();
    }

    public static void scoreToSMF(Score score, SMF smf) {
        System.out.println("Converting to SMF data structure...");
        double scoreTempo = score.getTempo();
        double partTempoMultiplier = 1.0;
        Track smfT = new Track();
        smfT.addEvent(new TempoEvent(0, score.getTempo()));
        smfT.addEvent(new TimeSig(0, score.getNumerator(), score.getDenominator()));
        smfT.addEvent(new KeySig(0, score.getKeySignature()));
        smfT.addEvent(new EndTrack());
        smf.getTrackList().addElement(smfT);
        int partCount = 0;
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Track smfTrack = new Track();
            Part inst = (Part)enume.nextElement();
            System.out.print("    Part " + partCount + " '" + inst.getTitle() + "' to SMF Track on Ch. " + inst.getChannel() + ": ");
            ++partCount;
            partTempoMultiplier = inst.getTempo() != -1.0 ? scoreTempo / inst.getTempo() : 1.0;
            int phraseNumb = inst.getPhraseList().size();
            int i = 0;
            while (i < phraseNumb) {
                Phrase phrase1 = (Phrase)inst.getPhraseList().elementAt(i);
                int j = 0;
                while (j < phraseNumb) {
                    Phrase phrase2 = (Phrase)inst.getPhraseList().elementAt(j);
                    if (phrase2.getStartTime() > phrase1.getStartTime()) {
                        inst.getPhraseList().setElementAt(phrase2, i);
                        inst.getPhraseList().setElementAt(phrase1, j);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            HashMap<Double, Event> midiEvents = new HashMap<Double, Event>();
            if (inst.getTempo() != -1.0) {
                midiEvents.put(new Double(0.0), new TempoEvent(inst.getTempo()));
            }
            if (inst.getInstrument() != -1) {
                midiEvents.put(new Double(0.0), new PChange((short)inst.getInstrument(), (short)inst.getChannel(), 0));
            }
            if (inst.getNumerator() != Integer.MIN_VALUE) {
                midiEvents.put(new Double(0.0), new TimeSig(inst.getNumerator(), inst.getDenominator()));
            }
            if (inst.getKeySignature() != Integer.MIN_VALUE) {
                midiEvents.put(new Double(0.0), new KeySig(inst.getKeySignature(), inst.getKeyQuality()));
            }
            Enumeration partEnum = inst.getPhraseList().elements();
            double max = 0.0;
            double startTime = 0.0;
            double offsetValue = 0.0;
            int phraseCounter = 0;
            double phraseTempoMultiplier = 1.0;
            while (partEnum.hasMoreElements()) {
                Phrase phrase = (Phrase)partEnum.nextElement();
                Enumeration phraseEnum = phrase.getNoteList().elements();
                startTime = phrase.getStartTime() * partTempoMultiplier;
                if (phrase.getInstrument() != -1) {
                    midiEvents.put(new Double(startTime), new PChange((short)phrase.getInstrument(), (short)inst.getChannel(), 0));
                }
                phraseTempoMultiplier = phrase.getTempo() != -1.0 ? scoreTempo * partTempoMultiplier / phrase.getTempo() : partTempoMultiplier;
                boolean noteCounter = false;
                System.out.print(" Phrase " + phraseCounter++ + ":");
                double pan = -1.0;
                MidiParser.resetTicker();
                while (phraseEnum.hasMoreElements()) {
                    Note note = (Note)phraseEnum.nextElement();
                    offsetValue = note.getOffset();
                    if (note.getPan() != pan) {
                        pan = note.getPan();
                        midiEvents.put(new Double(startTime + offsetValue), new CChange(10, (short)(pan * 127.0), (short)inst.getChannel(), 0));
                    }
                    int pitch = 0;
                    if (note.getPitchType()) {
                        System.err.println("jMusic warning: converting note frequency to the closest MIDI pitch for SMF.");
                        pitch = Note.freqToMidiPitch(note.getFrequency());
                    } else {
                        pitch = note.getPitch();
                    }
                    if (pitch != Integer.MIN_VALUE) {
                        midiEvents.put(new Double(startTime + offsetValue), new NoteOn((short)pitch, (short)note.getDynamic(), (short)inst.getChannel(), 0));
                        double endTime = startTime + note.getDuration() * phraseTempoMultiplier;
                        midiEvents.put(new Double(endTime + offsetValue), new NoteOn((short)pitch, 0, (short)inst.getChannel(), 0));
                    }
                    startTime += MidiParser.tickRounder(note.getRhythmValue() * phraseTempoMultiplier);
                    System.out.print(".");
                }
            }
            Object[] keys = midiEvents.keySet().toArray();
            Arrays.sort(keys);
            double st = 0.0;
            MidiParser.resetTicker();
            int index = 0;
            while (index < keys.length) {
                Event event = (Event)midiEvents.get(keys[index]);
                double sortStart = (Double)keys[index];
                int time = (int)((sortStart - st) * (double)smf.getPPQN() * partTempoMultiplier + 0.5);
                st = sortStart;
                event.setTime(time);
                smfTrack.addEvent(event);
                ++index;
            }
            smfTrack.addEvent(new EndTrack());
            smf.getTrackList().addElement(smfTrack);
            System.out.println();
        }
    }

    private static boolean zeroVelEventQ(Event e) {
        return e.getID() == 5 && ((NoteOn)e).getVelocity() == 0;
    }

    private static void resetTicker() {
        tickRemainder = 0.0;
    }

    private static double tickRounder(double timeValue) {
        double tick = 0.0020833333333333333;
        double halfTick = 0.0010416666666666667;
        int ticks = (int)(timeValue * 480.0);
        double rounded = (double)ticks * 0.0020833333333333333;
        if ((tickRemainder += timeValue - rounded) > 0.0010416666666666667) {
            rounded += 0.0020833333333333333;
            tickRemainder -= 0.0020833333333333333;
        }
        return rounded;
    }
}

