/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.gui.wave.WaveRuler;
import jm.gui.wave.WaveView;

public class WaveScrollPanel
extends Panel
implements ActionListener,
AdjustmentListener {
    private Label name;
    private Label bitSize;
    private Label sampleRate;
    private Label channels;
    private Label resLable;
    private Button minus;
    private Button plus;
    private Button play;
    private Button stop;
    private WaveView viewer;
    private WaveRuler ruler = new WaveRuler();
    private Panel resizePanel;
    private Scrollbar scroll = new Scrollbar(0);
    private Font font = new Font("Helvetica", 0, 10);

    public WaveScrollPanel() {
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.resizePanel = new Panel();
        this.resLable = new Label("Display Resolution: 1:0");
        this.resLable.setFont(this.font);
        this.resizePanel.add(this.resLable);
        this.minus = new Button("-");
        this.minus.addActionListener(this);
        this.resizePanel.add(this.minus);
        this.plus = new Button("+");
        this.plus.addActionListener(this);
        this.resizePanel.add(this.plus);
        this.add((Component)this.resizePanel, "East");
        Panel infoPanel = new Panel();
        this.play = new Button("Play");
        this.play.addActionListener(this);
        infoPanel.add(this.play);
        this.stop = new Button("Stop");
        this.stop.setEnabled(false);
        this.stop.addActionListener(this);
        infoPanel.add(this.stop);
        this.name = new Label();
        this.name.setFont(this.font);
        infoPanel.add(this.name);
        this.bitSize = new Label();
        this.bitSize.setFont(this.font);
        infoPanel.add(this.bitSize);
        this.sampleRate = new Label();
        this.sampleRate.setFont(this.font);
        infoPanel.add(this.sampleRate);
        this.channels = new Label();
        this.channels.setFont(this.font);
        infoPanel.add(this.channels);
        this.add((Component)infoPanel, "West");
        this.scroll.addAdjustmentListener(this);
        this.add((Component)this.scroll, "South");
        this.ruler.setWaveScrollPanel(this);
        this.add((Component)this.ruler, "North");
    }

    public void setViewer(WaveView viewer) {
        this.viewer = viewer;
        this.setResolution(viewer.getResolution());
    }

    public void setScrollbarAttributes(int waveSize, int frameWidth, int resolution) {
        this.scroll.setUnitIncrement(1000);
        this.scroll.setBlockIncrement(frameWidth * resolution / 2);
        this.scroll.setMinimum(0);
        this.scroll.setMaximum(waveSize * 2);
        this.scroll.setVisibleAmount(frameWidth * resolution);
    }

    public void setScrollbarResolution(int resolution) {
        if (this.viewer != null) {
            this.scroll.setVisibleAmount(this.viewer.getWidth() * resolution);
            this.scroll.setBlockIncrement(this.viewer.getWidth() * resolution / 2);
        } else {
            this.scroll.setVisibleAmount(204800);
            this.scroll.setBlockIncrement(102400);
        }
    }

    public void setScrollbarValue(int newValue) {
        this.scroll.setValue(newValue);
    }

    public void setResolution(int res) {
        String resStr = new String("Display Resolution = 1:" + res);
        if (res < 1000) {
            resStr = String.valueOf(resStr) + "  ";
        }
        this.resLable.setText(resStr);
        this.ruler.setMarkerWidth(this.viewer.getSampleRate() / res);
        this.repaint();
    }

    public void setFileName(String fileName) {
        this.name.setText("File = " + fileName + ". ");
        this.repaint();
    }

    public void setBitSize(int bits) {
        this.bitSize.setText("Bit Depth = " + bits + ". ");
        this.repaint();
    }

    public void setSampleRate(int rate) {
        this.sampleRate.setText("Sample Rate = " + rate + ". ");
        this.repaint();
    }

    public void setChannels(int chan) {
        this.channels.setText("Channels = " + chan + ". ");
        this.repaint();
    }

    public WaveRuler getWaveRuler() {
        return this.ruler;
    }

    public WaveView getWaveView() {
        return this.viewer;
    }

    public void actionPerformed(ActionEvent e) {
        int res;
        if (e.getSource() == this.minus && (res = this.viewer.getResolution()) > 0 && res <= 1024) {
            this.setResolution(res *= 2);
            this.plus.setEnabled(true);
            if (res > 1024) {
                this.minus.setEnabled(false);
            }
            this.viewer.setResolution(res);
        }
        if (e.getSource() == this.plus && (res = this.viewer.getResolution()) > 1) {
            this.setResolution(res /= 2);
            this.minus.setEnabled(true);
            if (res < 2) {
                this.plus.setEnabled(false);
            }
            this.viewer.setResolution(res);
        }
        if (e.getSource() == this.play) {
            this.stop.setEnabled(true);
            this.viewer.playFile();
        }
        if (e.getSource() == this.stop) {
            this.viewer.pauseFile();
            this.stop.setEnabled(false);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.viewer.setStartPos(this.scroll.getValue());
        this.ruler.repaint();
    }
}

