/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.gui.wave.WaveScrollPanel;

public class WaveRuler
extends Panel
implements MouseListener,
MouseMotionListener {
    private WaveScrollPanel scrollPanel;
    private int markerWidth;
    private int startX;
    private double tempRes;
    private Font font = new Font("Helvetica", 0, 9);
    private int startSecond = 0;

    public WaveRuler() {
        this.setBackground(Color.lightGray);
        this.setSize(new Dimension(800, 20));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setWaveScrollPanel(WaveScrollPanel scrollPanel) {
        this.scrollPanel = scrollPanel;
    }

    public void setMarkerWidth(int newWidth) {
        if (newWidth > 0) {
            this.markerWidth = newWidth;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        int k;
        int j;
        g.setColor(Color.darkGray);
        g.setFont(this.font);
        int max = this.getSize().width;
        int startLoc = -1 * this.scrollPanel.getWaveView().getStartPos();
        int secInc = this.markerWidth;
        int tenthInc = (int)Math.round((double)this.markerWidth / 10.0);
        int centInc = (int)Math.round((double)this.markerWidth / 100.0);
        int milliInc = (int)Math.round((double)this.markerWidth / 1000.0);
        int res = this.scrollPanel.getWaveView().getResolution();
        this.startSecond = this.scrollPanel.getWaveView().getStartPos() / this.scrollPanel.getWaveView().getSampleRate() / this.scrollPanel.getWaveView().getChannels();
        int counter = 0;
        g.setColor(Color.white);
        if (this.markerWidth > 20000) {
            j = startLoc / res;
            while (j < max) {
                k = 0;
                while (k < 10) {
                    int m = 0;
                    while (m < 10) {
                        int i = 0;
                        while (i < 10) {
                            if (counter % 10 != 0) {
                                int pos = j + k * tenthInc + m * centInc + i * milliInc;
                                g.drawLine(pos, this.getSize().height / 8 * 7, pos, this.getSize().height);
                                if (this.markerWidth > 40000) {
                                    g.drawString("" + ((double)this.startSecond + (double)counter / 1000.0), pos + 2, this.getSize().height - 1);
                                }
                            }
                            ++counter;
                            ++i;
                        }
                        ++m;
                    }
                    ++k;
                }
                j += secInc;
            }
        }
        counter = 0;
        g.setColor(Color.magenta);
        if (this.markerWidth > 1200) {
            j = startLoc / res;
            while (j < max) {
                k = 0;
                while (k < 10) {
                    int i = 0;
                    while (i < 10) {
                        if (counter % 10 != 0) {
                            int pos = j + k * tenthInc + i * centInc;
                            g.drawLine(pos, this.getSize().height / 4 * 3, pos, this.getSize().height);
                            if (this.markerWidth > 4800) {
                                g.drawString("" + ((double)this.startSecond + (double)counter / 100.0), pos + 2, this.getSize().height - 1);
                            }
                        }
                        ++counter;
                        ++i;
                    }
                    ++k;
                }
                j += secInc;
            }
        }
        counter = 0;
        g.setColor(Color.blue);
        if (this.markerWidth > 150) {
            j = startLoc / res;
            while (j < max) {
                int i = 0;
                while (i < 10) {
                    if (counter % 10 != 0) {
                        int pos = j + i * tenthInc;
                        g.drawLine(pos, this.getSize().height / 2, pos, this.getSize().height);
                        if (this.markerWidth > 300) {
                            g.drawString("" + ((double)this.startSecond + (double)counter / 10.0), pos + 2, this.getSize().height - 1);
                        }
                    }
                    ++counter;
                    ++i;
                }
                j += secInc;
            }
        }
        counter = 0;
        g.setColor(Color.red);
        int i = startLoc / res;
        while (i < max) {
            g.drawLine(i, 1, i, this.getSize().height);
            if (this.markerWidth > 20 && this.markerWidth <= 300) {
                g.drawString("" + (this.startSecond + counter), i + 2, this.getSize().height - 1);
            } else if (this.markerWidth > 300) {
                g.drawString("" + ((double)this.startSecond + (double)counter / 1.0), i + 2, this.getSize().height - 1);
            }
            ++counter;
            i += secInc;
        }
    }

    public void mousePressed(MouseEvent e) {
        this.setCursor(new Cursor(10));
        this.startX = e.getX();
        this.tempRes = this.scrollPanel.getWaveView().getResolution();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setCursor(new Cursor(13));
        this.scrollPanel.getWaveView().setResolution((int)this.tempRes);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int dist = 5;
        if (e.getX() > this.startX + dist) {
            this.tempRes = this.tempRes < 8.0 ? (double)Math.round(this.tempRes / 2.0) : (double)Math.round(this.tempRes / 1.1);
            if (this.tempRes < 1.0) {
                this.tempRes = 1.0;
            }
            if (this.tempRes > 2048.0) {
                this.tempRes = 2048.0;
            }
            this.scrollPanel.setResolution((int)Math.round(this.tempRes));
            this.startX = e.getX();
            this.repaint();
        }
        if (e.getX() < this.startX - dist) {
            this.tempRes = this.tempRes < 8.0 ? (double)Math.round(this.tempRes * 2.0) : (double)Math.round(this.tempRes * 1.1);
            if (this.tempRes < 1.0) {
                this.tempRes = 1.0;
            }
            if (this.tempRes > 2048.0) {
                this.tempRes = 2048.0;
            }
            this.scrollPanel.setResolution((int)Math.round(this.tempRes));
            this.startX = e.getX();
            this.repaint();
        }
    }
}

