/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.sketch;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.gui.sketch.SketchScore;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.music.tools.Mod;

public class SketchScoreArea
extends Canvas
implements JMC,
KeyListener,
MouseListener,
MouseMotionListener {
    private Score score;
    private int scoreChannels;
    private int currentChannel;
    private int oldY = 0;
    private Color[] theColors = new Color[10];
    private int maxWidth;
    private double beatWidth;
    private int x;
    private int y;
    private int newWidth = 650;
    private Vector drawPoints = new Vector();
    private int myHeight = 127;
    private SketchScore sc;

    public SketchScoreArea(Score score, int maxWidth, double beatWidth) {
        this.score = score;
        this.currentChannel = this.scoreChannels = score.size();
        this.maxWidth = maxWidth;
        this.beatWidth = beatWidth;
        this.setSize(maxWidth, this.myHeight);
        this.score = score;
        this.maxWidth = maxWidth;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(new Color(255, 255, 255));
        int i = 0;
        while (i < 10) {
            Color colour;
            this.theColors[i] = colour = new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
            ++i;
        }
    }

    public void setBeatWidth(double beatWidth) {
        this.beatWidth = beatWidth;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public void setSketchScore(SketchScore sc) {
        this.sc = sc;
    }

    public int getNewWidth() {
        return this.newWidth;
    }

    public void paint(Graphics g) {
        this.score.clean();
        Enumeration enume = this.score.getPartList().elements();
        int i = 0;
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            g.setColor(this.theColors[i % 10]);
            ++i;
            Enumeration enum2 = part.getPhraseList().elements();
            while (enum2.hasMoreElements()) {
                Phrase phrase = (Phrase)enum2.nextElement();
                Enumeration enum3 = phrase.getNoteList().elements();
                double oldStartTime = phrase.getStartTime();
                while (enum3.hasMoreElements()) {
                    Note aNote = (Note)enum3.nextElement();
                    int currNote = -1;
                    currNote = !aNote.getPitchType() ? aNote.getPitch() : Note.freqToMidiPitch(aNote.getFrequency());
                    if (currNote != Integer.MIN_VALUE) {
                        int x = 127 - currNote;
                        int y = (int)Math.round(aNote.getDuration() * this.beatWidth);
                        int oldY = (int)Math.round(oldStartTime * this.beatWidth);
                        g.drawLine(oldY, x, oldY + y, x);
                    }
                    oldStartTime += aNote.getRhythmValue();
                }
            }
        }
        g.setColor(Color.black);
        Enumeration drawEnum = this.drawPoints.elements();
        while (drawEnum.hasMoreElements()) {
            int x1 = (Integer)drawEnum.nextElement();
            int y1 = (Integer)drawEnum.nextElement();
            int x2 = (Integer)drawEnum.nextElement();
            int y2 = (Integer)drawEnum.nextElement();
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\b') {
            if (this.score.getPart(0).size() < 1) {
                return;
            }
            Vector v = this.score.getPartList();
            v.removeElementAt(v.size() - 1);
            if (this.sc == null) {
                this.repaint();
            } else {
                this.sc.update();
            }
            this.newWidth = 50;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    public void mouseDragged(MouseEvent e) {
        this.drawPoints.addElement(new Integer(this.x));
        this.drawPoints.addElement(new Integer(this.y));
        this.drawPoints.addElement(new Integer(e.getX()));
        this.drawPoints.addElement(new Integer(e.getY()));
        this.x = e.getX();
        this.y = e.getY();
        if (e.getX() > (int)(this.score.getEndTime() * this.beatWidth) && e.getX() > this.newWidth) {
            this.newWidth = e.getX();
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.drawPoints.size() > 0) {
            if (e.getModifiers() == 24) {
                this.convertLineToPhrase(true);
            } else {
                this.convertLineToPhrase(false);
            }
        }
        this.drawPoints.removeAllElements();
        this.newWidth = 50;
        this.repaint();
    }

    private void convertLineToPhrase(boolean hiRes) {
        Phrase phr = null;
        double[][] storer = new double[this.drawPoints.size() / 4][3];
        Enumeration drawEnum = this.drawPoints.elements();
        int counter = 0;
        while (drawEnum.hasMoreElements()) {
            int x1 = (Integer)drawEnum.nextElement();
            int y1 = (Integer)drawEnum.nextElement();
            int x2 = (Integer)drawEnum.nextElement();
            int y2 = (Integer)drawEnum.nextElement();
            if (hiRes) {
                int i = 0;
                while (i < Math.abs(y1 - y2)) {
                    storer[counter][0] = (double)((Integer)this.drawPoints.elementAt(counter * 4)).intValue() / this.beatWidth + ((double)Math.abs(x2 - x1) / this.beatWidth / (double)Math.abs(y1 - y2) + 1.0) / (double)(Math.abs(y1 - y2) + 1);
                    if ((Integer)this.drawPoints.elementAt(counter * 4) > (Integer)this.drawPoints.elementAt(counter * 4 + 2)) {
                        storer[counter][0] = (double)((Integer)this.drawPoints.elementAt(counter * 4 + 2)).intValue() / this.beatWidth / (double)Math.abs(y1 - y2) + 1.0;
                    }
                    storer[counter][1] = 127 - y1 + i;
                    storer[counter][2] = (double)Math.abs(x2 - x1) / this.beatWidth / (double)Math.abs(y1 - y2) + 1.0;
                    ++i;
                }
            } else {
                storer[counter][0] = (double)((Integer)this.drawPoints.elementAt(counter * 4)).intValue() / this.beatWidth;
                if ((Integer)this.drawPoints.elementAt(counter * 4) > (Integer)this.drawPoints.elementAt(counter * 4 + 2)) {
                    storer[counter][0] = (double)((Integer)this.drawPoints.elementAt(counter * 4 + 2)).intValue() / this.beatWidth;
                }
                storer[counter][1] = 127 - y1;
                storer[counter][2] = (double)Math.abs(x2 - x1) / this.beatWidth;
            }
            ++counter;
        }
        this.quickSort(storer, 0, storer.length - 1);
        if (this.drawPoints.size() > 0) {
            phr = new Phrase(storer[0][0]);
        }
        int i = 0;
        while (i < storer.length - 1) {
            if (storer[i][1] < 0.0) {
                storer[i][1] = 0.0;
            }
            if (storer[i][1] > 127.0) {
                storer[i][1] = 127.0;
            }
            Note n = new Note((int)storer[i][1], storer[i + 1][0] - storer[i][0]);
            if (i > 0 && !n.getPitchType() && !((Note)phr.getNoteList().lastElement()).getPitchType()) {
                if (phr.size() > 0 && n.getPitch() == ((Note)phr.getNoteList().lastElement()).getPitch()) {
                    Mod.append((Note)phr.getNoteList().lastElement(), n);
                } else {
                    phr.addNote(n);
                }
            } else {
                phr.addNote(n);
            }
            ++i;
        }
        if (storer[storer.length - 1][1] < 0.0) {
            storer[storer.length - 1][1] = 0.0;
        }
        if (storer[storer.length - 1][1] > 127.0) {
            storer[storer.length - 1][1] = 127.0;
        }
        Note n = new Note((int)storer[storer.length - 1][1], storer[storer.length - 1][2]);
        n.setDuration(storer[storer.length - 1][2]);
        phr.addNote(n);
        if (phr != null) {
            ++this.currentChannel;
            if (this.currentChannel > 15) {
                this.currentChannel = this.scoreChannels;
            }
            Part p = new Part("Sketch Part", 0, this.currentChannel);
            p.addPhrase(phr);
            this.score.addPart(p);
        }
    }

    private void quickSort(double[][] storer, int left, int right) {
        if (left >= right) {
            return;
        }
        SketchScoreArea.swap(storer, left, (int)(Math.random() * (double)(right - left)) + left);
        int last = left;
        int i = left + 1;
        while (i <= right) {
            if (storer[i][0] <= storer[left][0]) {
                SketchScoreArea.swap(storer, ++last, i);
            }
            ++i;
        }
        SketchScoreArea.swap(storer, left, last);
        this.quickSort(storer, left, last - 1);
        this.quickSort(storer, last + 1, right);
    }

    static void swap(double[][] storer, int i, int j) {
        int a = 0;
        while (a < 3) {
            double temp = storer[i][a];
            storer[i][a] = storer[j][a];
            storer[j][a] = temp;
            ++a;
        }
    }
}

