/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.sketch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import jm.gui.sketch.SketchRuler;
import jm.gui.sketch.SketchScoreArea;
import jm.midi.MidiSynth;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.Write;

public class SketchScore
extends Frame
implements WindowListener,
ActionListener {
    private static int maxWidth;
    private static int maxParts;
    protected static Score score;
    protected double beatWidth = 10.0;
    private Panel pan;
    private SketchScoreArea sketchScoreArea;
    private SketchRuler ruler;
    private MenuItem play;
    private MenuItem speedUp;
    private MenuItem slowDown;
    private MenuItem clear;
    private MenuItem saveMIDI;
    private MenuItem quit;
    private MenuItem openMIDI;
    private MenuItem openXML;
    private MenuItem saveXML;

    public SketchScore(Score score) {
        this(score, 0, 0);
    }

    public SketchScore(Score score, int xPos, int yPos) {
        super("jMusic Sketch: '" + score.getTitle() + "'");
        SketchScore.score = score;
        this.getWidthAndParts();
        this.addWindowListener(this);
        this.pan = new Panel();
        this.pan.setLayout(new BorderLayout());
        this.sketchScoreArea = new SketchScoreArea(score, maxWidth, this.beatWidth);
        this.sketchScoreArea.setSketchScore(this);
        this.pan.add("Center", this.sketchScoreArea);
        this.ruler = new SketchRuler(this);
        this.pan.add("South", this.ruler);
        ScrollPane sp = new ScrollPane(1);
        sp.getHAdjustable().setUnitIncrement(20);
        sp.add(this.pan);
        this.add(sp);
        MenuBar menus = new MenuBar();
        Menu fileMenu = new Menu("Sketch", true);
        this.play = new MenuItem("Play @ " + score.getTempo() + " bpm", new MenuShortcut(80));
        this.play.addActionListener(this);
        fileMenu.add(this.play);
        this.speedUp = new MenuItem("Speed Up");
        this.speedUp.addActionListener(this);
        fileMenu.add(this.speedUp);
        this.slowDown = new MenuItem("Slow Down");
        this.slowDown.addActionListener(this);
        fileMenu.add(this.slowDown);
        this.clear = new MenuItem("Clear notes");
        this.clear.addActionListener(this);
        fileMenu.add(this.clear);
        MenuItem dash = new MenuItem("-");
        fileMenu.add(dash);
        this.openMIDI = new MenuItem("Open a MIDI file...", new MenuShortcut(79));
        this.openMIDI.addActionListener(this);
        fileMenu.add(this.openMIDI);
        this.openXML = new MenuItem("Open a jMusic XML file...");
        this.openXML.addActionListener(this);
        fileMenu.add(this.openXML);
        this.saveMIDI = new MenuItem("Save as MIDI file", new MenuShortcut(83));
        this.saveMIDI.addActionListener(this);
        fileMenu.add(this.saveMIDI);
        this.saveXML = new MenuItem("Save as a jMusic XML file");
        this.saveXML.addActionListener(this);
        fileMenu.add(this.saveXML);
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        fileMenu.add(this.quit);
        menus.add(fileMenu);
        this.setMenuBar(menus);
        ((Component)this).setSize(650, this.sketchScoreArea.getHeight() + this.ruler.getHeight());
        ((Component)this).setLocation(xPos, yPos);
        this.show();
    }

    public SketchScoreArea getSketchScoreArea() {
        return this.sketchScoreArea;
    }

    public void windowClosing(WindowEvent we) {
        this.dispose();
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    public void update() {
        this.sketchScoreArea.setScore(score);
        this.pan.repaint();
        this.sketchScoreArea.setSize((int)Math.round(score.getEndTime() * this.beatWidth), this.sketchScoreArea.getHeight());
        this.sketchScoreArea.setBeatWidth(this.beatWidth);
        this.sketchScoreArea.repaint();
        this.ruler.repaint();
        ((Component)this).setSize(this.getSize().width, this.sketchScoreArea.getHeight() + this.ruler.getHeight());
        this.pack();
    }

    private void getWidthAndParts() {
        Enumeration enume = score.getPartList().elements();
        while (enume.hasMoreElements()) {
            Part part = (Part)enume.nextElement();
            ++maxParts;
            Enumeration enum2 = part.getPhraseList().elements();
            while (enum2.hasMoreElements()) {
                Phrase phrase = (Phrase)enum2.nextElement();
                Enumeration enum3 = phrase.getNoteList().elements();
                maxWidth = (int)(phrase.getStartTime() * this.beatWidth);
                while (enum3.hasMoreElements()) {
                    Note aNote = (Note)enum3.nextElement();
                    maxWidth += (int)(aNote.getRhythmValue() * this.beatWidth);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.play) {
            this.playScore();
        }
        if (e.getSource() == this.speedUp) {
            this.speedItUp();
        }
        if (e.getSource() == this.slowDown) {
            this.slowItDown();
        }
        if (e.getSource() == this.clear) {
            this.clearNotes();
        }
        if (e.getSource() == this.quit) {
            System.exit(0);
        }
        if (e.getSource() == this.saveMIDI) {
            this.saveMidi();
        }
        if (e.getSource() == this.openMIDI) {
            this.openMidi();
        }
        if (e.getSource() == this.saveXML) {
            this.saveXMLFile();
        }
        if (e.getSource() == this.openXML) {
            this.openXMLFile();
        }
    }

    private void playScore() {
        MidiSynth ms = new MidiSynth();
        try {
            ms.play(score);
        }
        catch (Exception e) {
            System.err.println("MIDI Playback Error:" + e);
            return;
        }
    }

    private void speedItUp() {
        double tempTempo = score.getTempo() + 10.0;
        if (tempTempo > 250.0) {
            tempTempo = 250.0;
        }
        score.setTempo(tempTempo);
        this.play.setLabel("Play @ " + tempTempo + " bpm");
    }

    private void slowItDown() {
        double tempTempo = score.getTempo() - 10.0;
        if (tempTempo < 20.0) {
            tempTempo = 20.0;
        }
        score.setTempo(tempTempo);
        this.play.setLabel("Play @ " + tempTempo + " bpm");
    }

    private void clearNotes() {
        score.removeAllParts();
        this.sketchScoreArea.repaint();
    }

    public void saveMidi() {
        FileDialog fd = new FileDialog((Frame)this, "Save as a MIDI file...", 1);
        fd.show();
        if (fd.getFile() != null) {
            Write.midi(score, String.valueOf(fd.getDirectory()) + fd.getFile());
        }
    }

    public void saveXMLFile() {
        FileDialog fd = new FileDialog(new Frame(), "Save as a jMusic XML file...", 1);
        fd.show();
        if (fd.getFile() != null) {
            Write.xml(score, String.valueOf(fd.getDirectory()) + fd.getFile());
        }
    }

    public void openMidi() {
        FileDialog fd = new FileDialog(new Frame(), "Select a MIDI file to display.", 0);
        fd.show();
        String fileName = fd.getFile();
        if (fileName != null) {
            Score score = new Score();
            Read.midi(score, String.valueOf(fd.getDirectory()) + fileName);
            SketchScore.score = score;
            this.update();
        }
    }

    public void openXMLFile() {
        FileDialog fd = new FileDialog(new Frame(), "Select a jMusic XML file to display.", 0);
        fd.show();
        String fileName = fd.getFile();
        if (fileName != null) {
            Score score = new Score();
            Read.xml(score, String.valueOf(fd.getDirectory()) + fileName);
            SketchScore.score = score;
            this.update();
        }
    }
}

