/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.sketch;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.gui.sketch.SketchScore;

public class SketchRuler
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener {
    private int startX;
    private int height = 15;
    private int barNumbCount = 2;
    private SketchScore sketchScore;
    private Font font = new Font("Helvetica", 0, 10);

    public SketchRuler(SketchScore sketchScore) {
        this.sketchScore = sketchScore;
        this.setSize((int)(SketchScore.score.getEndTime() * sketchScore.beatWidth), this.height);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setCursor(new Cursor(13));
    }

    public int getHeight() {
        return this.height;
    }

    public void paint(Graphics g) {
        double beatWidth = this.sketchScore.beatWidth;
        g.setFont(this.font);
        int i = 0;
        while (i < this.sketchScore.getSketchScoreArea().getNewWidth()) {
            int xLoc = (int)Math.round((double)i * beatWidth);
            if (i % this.barNumbCount == 0) {
                g.drawLine(xLoc, 0, xLoc, this.height);
                if (beatWidth > 15.0) {
                    g.drawString("" + i, xLoc + 2, this.height - 2);
                }
            } else {
                g.drawLine(xLoc, this.height / 2, xLoc, this.height);
            }
            ++i;
        }
    }

    public void mousePressed(MouseEvent e) {
        this.setCursor(new Cursor(10));
        this.startX = e.getX();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setCursor(new Cursor(13));
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        double beatWidth = this.sketchScore.beatWidth;
        if ((beatWidth += ((double)e.getX() - (double)this.startX) / 5.0) < 1.0) {
            beatWidth = 1.0;
        }
        if (beatWidth > 256.0) {
            beatWidth = 256.0;
        }
        this.sketchScore.beatWidth = beatWidth;
        this.startX = e.getX();
        this.sketchScore.update();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\b') {
            this.repaint();
        }
    }
}

