/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.show;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.gui.show.ShowPanel;

public class ShowRuler
extends Canvas
implements MouseListener,
MouseMotionListener {
    private int startX;
    private int height = 15;
    private int timeSig = 2;
    private ShowPanel sp;
    private Font font = new Font("Helvetica", 0, 10);

    public ShowRuler(ShowPanel sp) {
        this.sp = sp;
        this.setSize((int)(sp.score.getEndTime() * sp.beatWidth), this.height);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(13));
    }

    public int getHeight() {
        return this.height;
    }

    public void paint(Graphics g) {
        double beatWidth = this.sp.beatWidth;
        g.setFont(this.font);
        int i = 0;
        while ((double)i < this.sp.score.getEndTime()) {
            int xLoc = (int)Math.round((double)i * beatWidth);
            if (i % this.timeSig == 0) {
                g.drawLine(xLoc, 0, xLoc, this.height);
                if (beatWidth > 15.0) {
                    g.drawString("" + i, xLoc + 2, this.height - 2);
                }
            } else {
                g.drawLine(xLoc, this.height / 2, xLoc, this.height);
            }
            ++i;
        }
    }

    public void mousePressed(MouseEvent e) {
        this.setCursor(new Cursor(10));
        this.startX = e.getX();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setCursor(new Cursor(13));
        this.sp.update();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        double beatWidth = this.sp.beatWidth;
        if ((beatWidth += ((double)e.getX() - (double)this.startX) / 5.0) < 1.0) {
            beatWidth = 1.0;
        }
        if (beatWidth > 256.0) {
            beatWidth = 256.0;
        }
        this.sp.beatWidth = beatWidth;
        this.startX = e.getX();
        this.repaint();
    }
}

