/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.histogram;

import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jm.JMC;
import jm.gui.histogram.Histogram;
import jm.music.data.Score;
import jm.util.Read;

public class HistogramFrame
extends Frame
implements WindowListener,
ActionListener,
JMC {
    private Score score = new Score();
    private MenuItem showPitch;
    private MenuItem showRhythm;
    private MenuItem showDynamic;
    private MenuItem showPan;
    private MenuItem open;
    private MenuItem openXml;
    private MenuItem saveAs;
    private MenuItem quit;
    private Histogram histo;

    public HistogramFrame() {
        this(new Score(), 0);
    }

    public HistogramFrame(Score score) {
        this(score, 0);
    }

    public HistogramFrame(Score score, int dataType) {
        this(score, dataType, 0, 0);
    }

    public HistogramFrame(Score score, int dataType, int xPos, int yPos) {
        super(score.getTitle());
        this.score = score;
        this.setTitle(dataType);
        ((Component)this).setBackground(Color.white);
        ((Component)this).setSize(350, 558);
        this.histo = new Histogram(score, dataType, 0, 0, this.getSize().width);
        ((Component)this).setLocation(xPos, yPos);
        this.add(this.histo);
        this.addWindowListener(this);
        MenuBar menus = new MenuBar();
        Menu histoMenu = new Menu("Histogram", true);
        this.showPitch = new MenuItem("Pitch", new MenuShortcut(80));
        this.showPitch.addActionListener(this);
        histoMenu.add(this.showPitch);
        this.showRhythm = new MenuItem("Rhythm", new MenuShortcut(82));
        this.showRhythm.addActionListener(this);
        histoMenu.add(this.showRhythm);
        this.showDynamic = new MenuItem("Dynamic", new MenuShortcut(68));
        this.showDynamic.addActionListener(this);
        histoMenu.add(this.showDynamic);
        this.showPan = new MenuItem("Pan", new MenuShortcut(80, true));
        this.showPan.addActionListener(this);
        histoMenu.add(this.showPan);
        MenuItem line = new MenuItem("-");
        histoMenu.add(line);
        this.open = new MenuItem("Open MIDI file...", new MenuShortcut(79));
        this.open.addActionListener(this);
        histoMenu.add(this.open);
        this.openXml = new MenuItem("Open jMusic XML file...");
        this.openXml.addActionListener(this);
        histoMenu.add(this.openXml);
        this.saveAs = new MenuItem("Save data as...", new MenuShortcut(83));
        this.saveAs.addActionListener(this);
        histoMenu.add(this.saveAs);
        MenuItem line2 = new MenuItem("-");
        histoMenu.add(line2);
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        histoMenu.add(this.quit);
        menus.add(histoMenu);
        this.setMenuBar(menus);
        ((Component)this).setVisible(true);
    }

    private void setTitle(int dataType) {
        if (dataType == 0) {
            this.setTitle("jMusic Pitch Histogram: '" + this.score.getTitle() + "'");
        }
        if (dataType == 1) {
            this.setTitle("jMusic Rhythm Histogram: '" + this.score.getTitle() + "'");
        }
        if (dataType == 2) {
            this.setTitle("jMusic Dynamic Histogram: '" + this.score.getTitle() + "'");
        }
        if (dataType == 3) {
            this.setTitle("jMusic Pan Histogram: '" + this.score.getTitle() + "'");
        }
    }

    private void changeDataType(int dataType) {
        this.setTitle(dataType);
        this.histo.setType(dataType);
        this.repaint();
    }

    public void windowClosing(WindowEvent we) {
        this.dispose();
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.showPitch) {
            this.changeDataType(0);
        }
        if (e.getSource() == this.showRhythm) {
            this.changeDataType(1);
        }
        if (e.getSource() == this.showDynamic) {
            this.changeDataType(2);
        }
        if (e.getSource() == this.showPan) {
            this.changeDataType(3);
        }
        if (e.getSource() == this.open) {
            this.openMIDIFile();
        }
        if (e.getSource() == this.openXml) {
            this.openXMLFile();
        }
        if (e.getSource() == this.saveAs) {
            this.histo.saveData();
        }
        if (e.getSource() == this.quit) {
            System.exit(0);
        }
    }

    public void openMIDIFile() {
        FileDialog fd = new FileDialog(new Frame(), "Select a MIDI file to display.", 0);
        fd.show();
        String fileName = fd.getFile();
        if (fileName != null) {
            Score score = new Score();
            Read.midi(score, String.valueOf(fd.getDirectory()) + fileName);
            this.score = score;
            this.histo.setScore(score);
            this.changeDataType(0);
        }
    }

    public void openXMLFile() {
        FileDialog fd = new FileDialog(new Frame(), "Select a jMusic XML file to display.", 0);
        fd.show();
        String fileName = fd.getFile();
        if (fileName != null) {
            Score score = new Score();
            Read.xml(score, String.valueOf(fd.getDirectory()) + fileName);
            this.score = score;
            this.histo.setScore(score);
            this.changeDataType(0);
        }
    }
}

