/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.helper;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.JMC;
import jm.audio.Instrument;
import jm.midi.MidiSynth;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Play;
import jm.util.Read;
import jm.util.View;
import jm.util.Write;

public class HelperGUI
extends Frame
implements JMC,
ActionListener,
AdjustmentListener {
    protected Score score = new Score();
    private Button composeBtn;
    private Button playBtn;
    private Button stopBtn;
    private Button showBtn;
    private Button sketchBtn;
    private Button histogramBtn;
    private Button printBtn;
    private Button saveBtn;
    private Button renderBtn;
    private Button notateBtn;
    private Button audioViewBtn;
    private Button audioPlayBtn;
    private Button audioStopBtn;
    private Button xmlOpenBtn;
    private Button xmlSaveBtn;
    private TextField midiName;
    private TextField audioName;
    private Scrollbar sliderA;
    private Scrollbar sliderB;
    private Scrollbar sliderC;
    private Scrollbar sliderD;
    private Scrollbar sliderE;
    private Label labelA;
    private Label labelB;
    private Label labelC;
    private Label labelD;
    private Label labelE;
    private Label commentLabA;
    private Label commentLabB;
    private Label commentLabC;
    private Label commentLabD;
    private Label commentLabE;
    protected Instrument[] insts;
    protected int variableA;
    protected int variableB;
    protected int variableC;
    protected int variableD;
    protected int variableE;
    private MidiSynth ms = new MidiSynth();
    private boolean playing = false;

    public HelperGUI() {
        super("jMusic Helper GUI");
        this.setLayout(new BorderLayout());
        Panel controls = new Panel();
        controls.setLayout(new GridLayout(13, 1));
        this.add((Component)controls, "North");
        Panel sliders = new Panel();
        sliders.setLayout(new GridLayout(6, 1));
        this.add((Component)sliders, "Center");
        Panel composeBtnPanel = new Panel();
        Panel viewBtnPanel1 = new Panel();
        Panel viewBtnPanel2 = new Panel();
        Panel midiSaveBtnPanel = new Panel();
        Panel midiPlayBtnPanel = new Panel();
        Panel audioViewBtnPanel = new Panel();
        Panel audioSaveBtnPanel = new Panel();
        Panel xmlBtnPanel = new Panel();
        Label create = new Label("Create and View");
        create.setAlignment(1);
        controls.add(create);
        controls.add(composeBtnPanel);
        controls.add(viewBtnPanel1);
        controls.add(viewBtnPanel2);
        Label midi = new Label("MIDI Options");
        midi.setAlignment(1);
        controls.add(midi);
        controls.add(midiPlayBtnPanel);
        controls.add(midiSaveBtnPanel);
        Label audio = new Label("Audio Options");
        audio.setAlignment(1);
        controls.add(audio);
        controls.add(audioSaveBtnPanel);
        controls.add(audioViewBtnPanel);
        Label xmlHeader = new Label("XML Options");
        xmlHeader.setAlignment(1);
        controls.add(xmlHeader);
        controls.add(xmlBtnPanel);
        Label variables = new Label("Control compositional parameters");
        variables.setAlignment(1);
        controls.add(variables);
        this.composeBtn = new Button("Compose");
        this.composeBtn.addActionListener(this);
        composeBtnPanel.add(this.composeBtn);
        this.playBtn = new Button("Play.midi()");
        this.playBtn.addActionListener(this);
        this.playBtn.setEnabled(false);
        midiPlayBtnPanel.add(this.playBtn);
        this.stopBtn = new Button("Stop MIDI");
        this.stopBtn.addActionListener(this);
        this.stopBtn.setEnabled(false);
        midiPlayBtnPanel.add(this.stopBtn);
        this.showBtn = new Button("View.show()");
        this.showBtn.addActionListener(this);
        this.showBtn.setEnabled(false);
        viewBtnPanel1.add(this.showBtn);
        this.notateBtn = new Button("View.notate()");
        this.notateBtn.addActionListener(this);
        this.notateBtn.setEnabled(false);
        viewBtnPanel1.add(this.notateBtn);
        this.printBtn = new Button("View.print()");
        this.printBtn.addActionListener(this);
        this.printBtn.setEnabled(false);
        viewBtnPanel1.add(this.printBtn);
        this.sketchBtn = new Button("View.sketch()");
        this.sketchBtn.addActionListener(this);
        this.sketchBtn.setEnabled(false);
        viewBtnPanel2.add(this.sketchBtn);
        this.histogramBtn = new Button("View.histogram()");
        this.histogramBtn.addActionListener(this);
        this.histogramBtn.setEnabled(false);
        viewBtnPanel2.add(this.histogramBtn);
        this.saveBtn = new Button("Write.midi()");
        this.saveBtn.addActionListener(this);
        this.saveBtn.setEnabled(false);
        midiSaveBtnPanel.add(this.saveBtn);
        this.midiName = new TextField("FileName.mid", 20);
        midiSaveBtnPanel.add(this.midiName);
        this.audioViewBtn = new Button("View.au()");
        this.audioViewBtn.addActionListener(this);
        this.audioViewBtn.setEnabled(false);
        audioViewBtnPanel.add(this.audioViewBtn);
        this.renderBtn = new Button("Write.au()");
        this.renderBtn.addActionListener(this);
        this.renderBtn.setEnabled(false);
        audioSaveBtnPanel.add(this.renderBtn);
        this.audioName = new TextField("FileName.au", 20);
        audioSaveBtnPanel.add(this.audioName);
        this.audioPlayBtn = new Button("Play.au()");
        this.audioPlayBtn.addActionListener(this);
        this.audioPlayBtn.setEnabled(false);
        audioViewBtnPanel.add(this.audioPlayBtn);
        this.xmlOpenBtn = new Button("Read.xml()");
        this.xmlOpenBtn.addActionListener(this);
        this.xmlOpenBtn.setEnabled(true);
        xmlBtnPanel.add(this.xmlOpenBtn);
        this.xmlSaveBtn = new Button("Write.xml()");
        this.xmlSaveBtn.addActionListener(this);
        this.xmlSaveBtn.setEnabled(false);
        xmlBtnPanel.add(this.xmlSaveBtn);
        Panel sliderAPanel = new Panel(new GridLayout(1, 3));
        this.labelA = new Label(" variableA = 0");
        sliderAPanel.add(this.labelA);
        this.sliderA = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderA.addAdjustmentListener(this);
        sliderAPanel.add(this.sliderA);
        this.commentLabA = new Label(" No Comment ");
        sliderAPanel.add(this.commentLabA);
        sliders.add(sliderAPanel);
        Panel sliderBPanel = new Panel(new GridLayout(1, 3));
        this.labelB = new Label(" variableB = 0");
        sliderBPanel.add(this.labelB);
        this.sliderB = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderB.addAdjustmentListener(this);
        sliderBPanel.add(this.sliderB);
        this.commentLabB = new Label(" No Comment ");
        sliderBPanel.add(this.commentLabB);
        sliders.add(sliderBPanel);
        Panel sliderCPanel = new Panel(new GridLayout(1, 3));
        this.labelC = new Label(" variableC = 0");
        sliderCPanel.add(this.labelC);
        this.sliderC = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderC.addAdjustmentListener(this);
        sliderCPanel.add(this.sliderC);
        this.commentLabC = new Label(" No Comment ");
        sliderCPanel.add(this.commentLabC);
        sliders.add(sliderCPanel);
        Panel sliderDPanel = new Panel(new GridLayout(1, 3));
        this.labelD = new Label(" variableD = 0");
        sliderDPanel.add(this.labelD);
        this.sliderD = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderD.addAdjustmentListener(this);
        sliderDPanel.add(this.sliderD);
        this.commentLabD = new Label(" No Comment ");
        sliderDPanel.add(this.commentLabD);
        sliders.add(sliderDPanel);
        Panel sliderEPanel = new Panel(new GridLayout(1, 3));
        this.labelE = new Label(" variableE = 0");
        sliderEPanel.add(this.labelE);
        this.sliderE = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderE.addAdjustmentListener(this);
        sliderEPanel.add(this.sliderE);
        this.commentLabE = new Label(" No Comment ");
        sliderEPanel.add(this.commentLabE);
        sliders.add(sliderEPanel);
        Label filler = new Label(" ");
        sliders.add(filler);
        ((Component)this).setBounds(0, 0, 350, 600);
        ((Component)this).setVisible(true);
        this.composeBtn.requestFocus();
    }

    public void setVariableA(int value) {
        this.setVariableA(value, "No Comment");
    }

    public void setVariableA(int value, String comment) {
        if (value >= 0 && value <= 127) {
            this.sliderA.setValue(value);
            this.labelA.setText(" variableA = " + value + "  ");
            this.variableA = value;
        }
        if (comment.length() > 18) {
            this.commentLabA.setText(" " + comment.substring(0, 16) + "...");
        } else {
            this.commentLabA.setText(" " + comment + " ");
        }
    }

    public void setVariableB(int value) {
        this.setVariableB(value, "No Comment");
    }

    public void setVariableB(int value, String comment) {
        if (value >= 0 && value <= 127) {
            this.sliderB.setValue(value);
            this.labelB.setText(" variableB = " + value + "  ");
            this.variableB = value;
        }
        if (comment.length() > 18) {
            this.commentLabB.setText(" " + comment.substring(0, 16) + "...");
        } else {
            this.commentLabB.setText(" " + comment + " ");
        }
    }

    public void setVariableC(int value) {
        this.setVariableC(value, "No Comment");
    }

    public void setVariableC(int value, String comment) {
        if (value >= 0 && value <= 127) {
            this.sliderC.setValue(value);
            this.labelC.setText(" variableC = " + value + "  ");
            this.variableC = value;
        }
        if (comment.length() > 18) {
            this.commentLabC.setText(" " + comment.substring(0, 16) + "...");
        } else {
            this.commentLabC.setText(" " + comment + " ");
        }
    }

    public void setVariableD(int value) {
        this.setVariableD(value, "No Comment");
    }

    public void setVariableD(int value, String comment) {
        if (value >= 0 && value <= 127) {
            this.sliderD.setValue(value);
            this.labelD.setText(" variableD = " + value + "  ");
            this.variableD = value;
        }
        if (comment.length() > 18) {
            this.commentLabD.setText(" " + comment.substring(0, 16) + "...");
        } else {
            this.commentLabD.setText(" " + comment + " ");
        }
    }

    public void setVariableE(int value) {
        this.setVariableE(value, "No Comment");
    }

    public void setVariableE(int value, String comment) {
        if (value >= 0 && value <= 127) {
            this.sliderE.setValue(value);
            this.labelE.setText(" variableE = " + value + "  ");
            this.variableE = value;
        }
        if (comment.length() > 18) {
            this.commentLabE.setText(" " + comment.substring(0, 16) + "...");
        } else {
            this.commentLabE.setText(" " + comment + " ");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.composeBtn) {
            this.composeScore();
        }
        if (e.getSource() == this.playBtn) {
            this.playScore();
        }
        if (e.getSource() == this.stopBtn) {
            this.stopScore();
        }
        if (e.getSource() == this.showBtn) {
            this.showScore();
        }
        if (e.getSource() == this.notateBtn) {
            this.notateScore();
        }
        if (e.getSource() == this.printBtn) {
            this.printScore();
        }
        if (e.getSource() == this.sketchBtn) {
            this.sketchScore();
        }
        if (e.getSource() == this.histogramBtn) {
            this.histogramScore();
        }
        if (e.getSource() == this.saveBtn) {
            this.saveScore();
        }
        if (e.getSource() == this.renderBtn) {
            this.renderScore();
        }
        if (e.getSource() == this.audioViewBtn) {
            this.viewAudio();
        }
        if (e.getSource() == this.audioPlayBtn) {
            this.playAudio();
        }
        if (e.getSource() == this.audioStopBtn) {
            this.stopAudio();
        }
        if (e.getSource() == this.xmlOpenBtn) {
            this.xmlOpen();
        }
        if (e.getSource() == this.xmlSaveBtn) {
            this.xmlSave();
        }
    }

    private void composeScore() {
        this.score = this.compose();
        this.makeBtnsVisible();
    }

    private void makeBtnsVisible() {
        this.playBtn.setEnabled(true);
        this.stopBtn.setEnabled(true);
        this.showBtn.setEnabled(true);
        this.notateBtn.setEnabled(true);
        this.printBtn.setEnabled(true);
        this.sketchBtn.setEnabled(true);
        this.histogramBtn.setEnabled(true);
        this.saveBtn.setEnabled(true);
        this.xmlSaveBtn.setEnabled(true);
        if (this.insts != null) {
            this.renderBtn.setEnabled(true);
        }
    }

    protected Score compose() {
        Phrase phrase = new Phrase();
        Score s = new Score(new Part(phrase));
        Note n = new Note(48 + (int)(Math.random() * (double)this.variableA), 0.5 + (double)this.variableB * 0.25);
        phrase.addNote(n);
        return s;
    }

    private void playScore() {
        if (this.playing) {
            this.ms.stop();
        }
        try {
            this.ms.play(this.score);
            this.playing = true;
        }
        catch (Exception e) {
            System.err.println("JavaSound MIDI Playback Error:" + e);
            return;
        }
    }

    private void stopScore() {
        if (this.playing) {
            this.ms.stop();
            this.playing = false;
        }
    }

    private void showScore() {
        View.show(this.score, this.getSize().width + 15, 0);
    }

    private void notateScore() {
        View.notate(this.score, this.getSize().width + 15, 0);
    }

    private void printScore() {
        View.print(this.score);
    }

    private void histogramScore() {
        View.histogram(this.score, 0, this.getSize().width + 15, 0);
    }

    private void sketchScore() {
        View.sketch(this.score, this.getSize().width + 15, 0);
    }

    private void saveScore() {
        String fileName = this.midiName.getText().trim();
        if (fileName != null) {
            Write.midi(this.score, fileName);
        } else {
            Write.midi(this.score);
        }
    }

    private void renderScore() {
        String fileName = this.audioName.getText().trim();
        if (fileName != null) {
            Write.au(this.score, fileName, this.insts);
        } else {
            Write.au(this.score, "RenderedFile.au", this.insts);
            this.audioName.setText("RenderedFile.au");
        }
        this.audioViewBtn.setEnabled(true);
        this.audioPlayBtn.setEnabled(true);
    }

    private void viewAudio() {
        View.au(this.audioName.getText().trim(), this.getSize().width + 5, 0);
    }

    private void playAudio() {
        Play.au(this.audioName.getText().trim(), false);
    }

    private void stopAudio() {
    }

    public void adjustmentValueChanged(AdjustmentEvent ae) {
        if (ae.getSource() == this.sliderA) {
            this.labelA.setText(" variableA = " + this.sliderA.getValue());
            this.variableA = new Integer(this.sliderA.getValue());
        }
        if (ae.getSource() == this.sliderB) {
            this.labelB.setText(" variableB = " + this.sliderB.getValue());
            this.variableB = new Integer(this.sliderB.getValue());
        }
        if (ae.getSource() == this.sliderC) {
            this.labelC.setText(" variableC = " + this.sliderC.getValue());
            this.variableC = new Integer(this.sliderC.getValue());
        }
        if (ae.getSource() == this.sliderD) {
            this.labelD.setText(" variableD = " + this.sliderD.getValue());
            this.variableD = new Integer(this.sliderD.getValue());
        }
        if (ae.getSource() == this.sliderE) {
            this.labelE.setText(" variableE = " + this.sliderE.getValue());
            this.variableE = new Integer(this.sliderE.getValue());
        }
    }

    private void xmlSave() {
        FileDialog fd = new FileDialog(new Frame(), "Save as a jMusic XML file...", 1);
        fd.show();
        if (fd.getFile() != null) {
            Write.xml(this.score, String.valueOf(fd.getDirectory()) + fd.getFile());
        }
    }

    private void xmlOpen() {
        Read.xml(this.score);
        this.makeBtnsVisible();
    }
}

