/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.graph;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jm.gui.graph.Statistics;
import jm.gui.graph.StatisticsList;

public abstract class GraphCanvas
extends Canvas {
    protected StatisticsList statsList;
    protected Image image;
    protected Graphics graphics;
    protected Dimension preferredSize = new Dimension(1, 1);
    protected Dimension minimumSize = new Dimension(1, 1);

    public GraphCanvas() {
        this(new Statistics());
    }

    public GraphCanvas(Statistics stats) {
        this.statsList = new StatisticsList();
        this.statsList.add(stats);
    }

    public GraphCanvas(Statistics[] statsArray) {
        this.statsList = new StatisticsList(statsArray.length * 110 / 100);
        int i = 0;
        while (i < statsArray.length) {
            this.statsList.add(statsArray[i]);
            ++i;
        }
    }

    public GraphCanvas(StatisticsList statsList) {
        this.statsList = statsList;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void addStatistics(Statistics stats) {
        this.statsList.add(stats);
    }

    protected abstract void paintBuffer();

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.image == null) {
            this.image = this.createImage(1, 1);
            this.graphics = this.image.getGraphics();
        }
        this.paintBuffer();
        g.drawImage(this.image, 0, 0, this);
    }
}

