/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import jm.JMC;
import jm.constants.Scales;
import jm.gui.cpn.Images;
import jm.gui.cpn.Stave;
import jm.music.data.Phrase;

public class TrebleStave
extends Stave
implements JMC {
    private Style style = new Style.JMusic();
    private int tonic = 0;
    protected int[] scale = Scales.MAJOR_SCALE;
    public static final int MAX_HEIGHT = 500;
    public static final int MAX_WIDTH = 2000;
    private double beatCounter;
    private boolean isFirstNoteInTie = true;
    private boolean firstAccidentalDisplayed = false;
    private boolean isTied = false;
    private boolean semitoneShiftUp = false;
    private boolean extraImagesUsed;
    private int savedBeatWidth;
    private int savedBeatWidth2;
    private int lastChordDisplayed = -1;
    private int lastPosition = 0;
    private String[] chordStrings = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "."};

    public void setAccidentalDisplayStyle(Style ads) {
        if (ads == Style.TRADITIONAL) {
            this.style = new Style.Trad();
        } else if (ads == Style.JMUSIC) {
            this.style = new Style.JMusic();
        } else {
            throw new RuntimeException("Unknown Accidental Display Style");
        }
    }

    public TrebleStave() {
    }

    public TrebleStave(Phrase phrase) {
        super(phrase);
    }

    public TrebleStave(Images images) {
        super(images);
    }

    public TrebleStave(Phrase phrase, Images images) {
        super(phrase, images);
    }

    public void paint(Graphics graphics) {
        int keyAccidentalPosition;
        int ks;
        if (this.image == null) {
            this.image = this.createImage(2000, 500);
            this.g = this.image.getGraphics();
        }
        this.g.setFont(this.font);
        this.beatCounter = 0.0;
        this.notePositions.removeAllElements();
        if (this.getDisplayTitle()) {
            this.g.drawString(this.title, this.rightMargin, this.bPos - 10);
        }
        int keyOffset = 0;
        this.style.initialise(this.keySignature);
        if (this.keySignature > 0 && this.keySignature < 8) {
            ks = 0;
            while (ks < this.keySignature) {
                keyAccidentalPosition = this.notePosOffset[this.sharps[ks] % 12] + this.bPos - 4 + (5 - this.sharps[ks] / 12) * 24 + (6 - this.sharps[ks] / 12) * 4;
                this.g.drawImage(this.sharp, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition, this);
                this.keySigWidth = keyOffset += 10;
                ++ks;
            }
        } else if (this.keySignature < 0 && this.keySignature > -8) {
            ks = 0;
            while (ks < Math.abs(this.keySignature)) {
                keyAccidentalPosition = this.notePosOffset[this.flats[ks] % 12] + this.bPos - 4 + (5 - this.flats[ks] / 12) * 24 + (6 - this.flats[ks] / 12) * 4;
                this.g.drawImage(this.flat, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition, this);
                keyOffset += 10;
                ++ks;
            }
        }
        this.keySigWidth = keyOffset + 3;
        if (this.metre != 0.0) {
            Image[] numbers = new Image[]{this.one, this.two, this.three, this.four, this.five, this.six, this.seven, this.eight, this.nine};
            this.g.drawImage(numbers[(int)this.metre - 1], this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 13, this);
            this.g.drawImage(this.four, this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 29, this);
            this.timeSigWidth = 30;
        } else {
            this.timeSigWidth = 5;
        }
        this.totalBeatWidth = this.rightMargin + this.clefWidth + this.keySigWidth + this.timeSigWidth;
        this.lastChordDisplayed = -1;
        int i = 0;
        while (i < this.phrase.size()) {
            int notePitchNum = this.phrase.getNote(i).getPitch();
            int pitchTempPos = notePitchNum == Integer.MIN_VALUE || this.phrase.getNote(i).getRhythmValue() == 0.0 ? this.notePosOffset[11] + this.bPos - 4 + 0 + 4 : this.notePosOffset[notePitchNum % 12] + this.bPos - 4 + (5 - notePitchNum / 12) * 24 + (6 - notePitchNum / 12) * 4;
            this.firstAccidentalDisplayed = false;
            this.semitoneShiftUp = false;
            this.isTied = false;
            this.isFirstNoteInTie = true;
            this.extraImagesUsed = false;
            this.savedBeatWidth = this.totalBeatWidth;
            this.savedBeatWidth2 = 0;
            double rhythmValue = this.phrase.getNote(i).getRhythmValue();
            double rvToEndOfBar = this.metre - this.beatCounter % this.metre;
            while (rvToEndOfBar < rhythmValue) {
                this.isTied = true;
                this.drawNote(notePitchNum, rvToEndOfBar, pitchTempPos);
                rhythmValue -= rvToEndOfBar;
                rvToEndOfBar = this.metre - this.beatCounter % this.metre;
            }
            this.drawNote(notePitchNum, rhythmValue, pitchTempPos);
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        this.g.setColor(Color.lightGray);
        i = 0;
        while (i < 5) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth + 50, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        this.g.setColor(Color.black);
        this.g.drawImage(this.trebleClef, this.rightMargin + 7, this.bPos - 4, this);
        graphics.drawImage(this.image, 0, 0, null);
        this.g.setColor(this.getBackground());
        this.g.fillRect(0, 0, 2000, 500);
        this.g.setColor(this.getForeground());
    }

    private void drawNote(int notePitchNum, double rhythmValue, int pitchTempPos) {
        this.requiresMoreThanOneImage = false;
        this.excessRhythmValue = 0.0;
        this.chooseImage(notePitchNum, rhythmValue, 71, 0, 71);
        this.drawNote2(notePitchNum, rhythmValue - this.excessRhythmValue, pitchTempPos);
        if (this.requiresMoreThanOneImage) {
            this.drawNote(notePitchNum, this.excessRhythmValue, pitchTempPos);
            this.extraImagesUsed = true;
        }
    }

    private void drawNote2(int pitch, double rhythmValue, int yCoordinate) {
        if (pitch != Integer.MIN_VALUE && rhythmValue != 0.0) {
            Accidental accidental = this.style.selectAccidental(pitch, rhythmValue);
            if (accidental == Accidental.SHARP) {
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.sharp, this.totalBeatWidth - 9, yCoordinate);
                }
            } else if (accidental == Accidental.FLAT) {
                yCoordinate -= 4;
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.flat, this.totalBeatWidth - 9, yCoordinate);
                }
                ++pitch;
                this.semitoneShiftUp = true;
            } else if (accidental == Accidental.NATURAL && !this.firstAccidentalDisplayed) {
                this.displayImage(this.g, this.natural, this.totalBeatWidth - 7, yCoordinate);
            }
        }
        this.firstAccidentalDisplayed = true;
        this.displayImage(this.g, this.currImage, this.totalBeatWidth, yCoordinate);
        this.notePositions.addElement(new Integer(this.totalBeatWidth));
        this.notePositions.addElement(new Integer(yCoordinate));
        if (this.dottedNote) {
            boolean dotFlag = true;
            int l = 0;
            while (l < this.lineNotes.length) {
                if (this.lineNotes[l] + 12 == pitch || this.lineNotes[l] + 36 == pitch || this.lineNotes[l] + 60 == pitch || this.lineNotes[l] + 84 == pitch || this.lineNotes[l] + 108 == pitch || pitch == Integer.MIN_VALUE) {
                    this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, yCoordinate - 4);
                    dotFlag = false;
                    l = this.lineNotes.length;
                }
                ++l;
            }
            if (dotFlag) {
                this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, yCoordinate);
            }
        }
        if (pitch <= 61 && pitch > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 52, this.totalBeatWidth + 12, this.bPos + 52);
        }
        if (pitch <= 58 && pitch > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 60, this.totalBeatWidth + 12, this.bPos + 60);
        }
        if (pitch <= 54 && pitch > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 68, this.totalBeatWidth + 12, this.bPos + 68);
        }
        if (pitch <= 51 && pitch > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 76, this.totalBeatWidth + 12, this.bPos + 76);
        }
        if (pitch <= 48 && pitch > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 84, this.totalBeatWidth + 12, this.bPos + 84);
        }
        if (pitch >= 81 && pitch < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 4, this.totalBeatWidth + 12, this.bPos + 4);
        }
        if (pitch >= 84 && pitch < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 4, this.totalBeatWidth + 12, this.bPos - 4);
        }
        if (pitch >= 88 && pitch < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 12, this.totalBeatWidth + 12, this.bPos - 12);
        }
        if (pitch >= 91 && pitch < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 20, this.totalBeatWidth + 12, this.bPos - 20);
        }
        if (pitch >= 95 && pitch < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 28, this.totalBeatWidth + 12, this.bPos - 28);
        }
        this.savedBeatWidth2 = this.totalBeatWidth;
        if ((this.isTied || this.extraImagesUsed) && this.isNote && !this.isFirstNoteInTie) {
            int yPosition = yCoordinate + 19 - (this.semitoneShiftUp ? 4 : 0);
            if (this.isUp) {
                this.g.drawImage(this.tieUnder, this.savedBeatWidth - 3 + 9, yPosition + 17, this.savedBeatWidth2 + 19 - 9, yPosition + 17 + this.tieUnder.getHeight(this), 0, 0, this.tieUnder.getWidth(this), this.tieUnder.getHeight(this), this);
            } else {
                this.g.drawImage(this.tieOver, this.savedBeatWidth - 3 + 9, yPosition - 20, this.savedBeatWidth2 + 19 - 9, yPosition - 20 + this.tieOver.getHeight(this), 0, 0, this.tieOver.getWidth(this), this.tieOver.getHeight(this), this);
            }
        }
        this.isFirstNoteInTie = true;
        if (true) {
            this.isFirstNoteInTie = false;
        }
        this.savedBeatWidth = this.totalBeatWidth;
        this.totalBeatWidth += this.currBeatWidth;
        this.dottedNote = false;
        this.beatCounter += (double)((int)(rhythmValue / 0.25)) * 0.25;
        if (this.metre != 0.0 && this.beatCounter % this.metre == 0.0) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + 12, this.totalBeatWidth, this.bPos + 44);
            this.style.processBarLine();
            if (this.barNumbers) {
                this.g.drawString("" + (int)(this.beatCounter / this.metre + 1.0 + this.phrase.getStartTime()), this.totalBeatWidth - 4, this.bPos);
            }
            this.totalBeatWidth += 12;
        }
    }

    private void displayImage(Graphics g, Image image, int xCoord, int yCoord) {
        g.drawImage(image, xCoord, yCoord, this);
    }

    private static final class Accidental {
        public static final Accidental NONE = new Accidental("none");
        public static final Accidental SHARP = new Accidental("sharp");
        public static final Accidental NATURAL = new Accidental("natural");
        public static final Accidental FLAT = new Accidental("flat");
        private String name;

        Accidental(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class Style {
        int[] sharpPitches = new int[]{77, 72, 79, 74, 69, 76, 71};
        int[] flatPitches = new int[]{71, 76, 69, 74, 67, 72, 65};
        public static final Style TRADITIONAL = new Trad();
        public static final Style JMUSIC = new JMusic();
        private String name;

        Style(String name) {
            this.name = name;
        }

        public String toString() {
            return String.valueOf(this.name) + " of displaying accidentals";
        }

        abstract void initialise(int var1);

        abstract Accidental selectAccidental(int var1, double var2);

        abstract void processBarLine();

        private static final class Trad
        extends Style {
            private boolean[] accidentalRequiredByKeySignature = new boolean[12];
            private static final int[] SHARP_ACCIDENTAL_PAIRS;
            private static final int[] FLAT_ACCIDENTAL_PAIRS;
            private int[] degreeToAccidentalPair = SHARP_ACCIDENTAL_PAIRS;
            private boolean[] accidentalInEffect = new boolean[7];
            private int keySignature = 0;

            static {
                int[] nArray = new int[12];
                nArray[2] = 1;
                nArray[3] = 1;
                nArray[4] = 2;
                nArray[5] = 3;
                nArray[6] = 3;
                nArray[7] = 4;
                nArray[8] = 4;
                nArray[9] = 5;
                nArray[10] = 5;
                nArray[11] = 6;
                SHARP_ACCIDENTAL_PAIRS = nArray;
                int[] nArray2 = new int[12];
                nArray2[1] = 1;
                nArray2[2] = 1;
                nArray2[3] = 2;
                nArray2[4] = 2;
                nArray2[5] = 3;
                nArray2[6] = 4;
                nArray2[7] = 4;
                nArray2[8] = 5;
                nArray2[9] = 5;
                nArray2[10] = 6;
                nArray2[11] = 6;
                FLAT_ACCIDENTAL_PAIRS = nArray2;
            }

            public Trad() {
                super("Traditional style");
                this.initialise(0);
            }

            private void setBooleanArrayToFalse(boolean[] array) {
                int i = 0;
                while (i < array.length) {
                    array[i] = false;
                    ++i;
                }
            }

            void initialise(int keySignature) {
                this.keySignature = keySignature;
                this.degreeToAccidentalPair = keySignature < 0 ? FLAT_ACCIDENTAL_PAIRS : SHARP_ACCIDENTAL_PAIRS;
                this.setBooleanArrayToFalse(this.accidentalRequiredByKeySignature);
                this.accidentalRequiredByKeySignature[1] = true;
                this.accidentalRequiredByKeySignature[3] = true;
                this.accidentalRequiredByKeySignature[6] = true;
                this.accidentalRequiredByKeySignature[8] = true;
                this.accidentalRequiredByKeySignature[10] = true;
                int i = 0;
                while (i < Math.abs(keySignature)) {
                    if (keySignature < 0) {
                        this.accidentalRequiredByKeySignature[this.flatPitches[i] % 12] = true;
                        this.accidentalRequiredByKeySignature[(this.flatPitches[i] - 1) % 12] = false;
                    } else {
                        this.accidentalRequiredByKeySignature[this.sharpPitches[i] % 12] = true;
                        this.accidentalRequiredByKeySignature[(this.sharpPitches[i] + 1) % 12] = false;
                    }
                    ++i;
                }
                this.setBooleanArrayToFalse(this.accidentalInEffect);
            }

            Accidental selectAccidental(int pitch, double rhythmValue) {
                if (pitch == Integer.MIN_VALUE || rhythmValue == 0.0) {
                    return Accidental.NONE;
                }
                int degree = pitch % 12;
                int accidentalPair = this.degreeToAccidentalPair[degree];
                if (this.accidentalRequiredByKeySignature[degree] ^ this.accidentalInEffect[accidentalPair]) {
                    boolean bl = this.accidentalInEffect[accidentalPair] = !this.accidentalInEffect[accidentalPair];
                    if (degree == 1 || degree == 3 || degree == 6 || degree == 8 || degree == 10) {
                        if (this.keySignature > -1) {
                            return Accidental.SHARP;
                        }
                        return Accidental.FLAT;
                    }
                    return Accidental.NATURAL;
                }
                return Accidental.NONE;
            }

            void processBarLine() {
                this.setBooleanArrayToFalse(this.accidentalInEffect);
            }
        }

        private static final class JMusic
        extends Style {
            private Vector chromaticallyAffectedPitches = new Vector();
            private int keySignature;
            private int keyAccidentals;

            public JMusic() {
                super("JMusic style (with superfluous sharps and flats)");
                this.initialise(0);
            }

            void initialise(int keySignature) {
                block7: {
                    block6: {
                        this.chromaticallyAffectedPitches = new Vector();
                        this.keySignature = keySignature;
                        this.keyAccidentals = 0;
                        if (keySignature <= 0 || keySignature >= 8) break block6;
                        int i = 0;
                        while (i < keySignature) {
                            int degree = this.sharpPitches[i] % 12;
                            int j = 0;
                            while (j <= 127) {
                                if (j % 12 == degree) {
                                    this.chromaticallyAffectedPitches.addElement(new Integer(j));
                                    ++this.keyAccidentals;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        break block7;
                    }
                    if (keySignature >= 0 || keySignature <= -8) break block7;
                    int i = 0;
                    while (i > keySignature) {
                        int degree = this.flatPitches[-i] % 12;
                        int j = 0;
                        while (j <= 127) {
                            if (j % 12 == degree) {
                                this.chromaticallyAffectedPitches.addElement(new Integer(j));
                                ++this.keyAccidentals;
                            }
                            ++j;
                        }
                        --i;
                    }
                }
            }

            Accidental selectAccidental(int pitch, double rhythmValue) {
                if (pitch == Integer.MIN_VALUE || rhythmValue == 0.0) {
                    return Accidental.NONE;
                }
                if (pitch % 12 == 1 || pitch % 12 == 3 || pitch % 12 == 6 || pitch % 12 == 8 || pitch % 12 == 10) {
                    if (this.keySignature > -1) {
                        this.chromaticallyAffectedPitches.addElement(new Integer(pitch - 1));
                        return Accidental.SHARP;
                    }
                    this.chromaticallyAffectedPitches.addElement(new Integer(pitch + 1));
                    return Accidental.FLAT;
                }
                int size = this.chromaticallyAffectedPitches.size();
                int j = 0;
                while (j < size) {
                    int temp = (Integer)this.chromaticallyAffectedPitches.elementAt(j);
                    if (temp == pitch) {
                        if (j > this.keyAccidentals - 1) {
                            this.chromaticallyAffectedPitches.removeElementAt(j);
                        }
                        return Accidental.NATURAL;
                    }
                    ++j;
                }
                return Accidental.NONE;
            }

            void processBarLine() {
            }
        }
    }
}

