/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.JMC;
import jm.gui.cpn.NoteEditor;
import jm.gui.cpn.Stave;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class StaveActionHandler
implements JMC,
MouseListener,
MouseMotionListener,
ActionListener,
KeyListener {
    private Stave theApp;
    private int selectedNote = -1;
    private boolean topTimeSelected = false;
    private boolean keySelected = false;
    private int clickedPosY;
    private int clickedPosX;
    private int storedPitch = 72;
    private double[] rhythmValues = new double[]{104.0, 103.0, 102.0, 101.5, 101.0, 100.75, 100.5, 100.25, 0.0, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0};
    private boolean button1Down = false;
    private PopupMenu noteContextMenu;
    private MenuItem editNote;
    private MenuItem repeatNote;
    private MenuItem makeRest;
    private MenuItem deleteNote;

    StaveActionHandler(Stave stave) {
        this.theApp = stave;
        this.noteContextMenu = new PopupMenu();
        this.editNote = new MenuItem("Edit Note");
        this.editNote.addActionListener(this);
        this.noteContextMenu.add(this.editNote);
        this.repeatNote = new MenuItem("Repeat Note");
        this.repeatNote.addActionListener(this);
        this.noteContextMenu.add(this.repeatNote);
        this.makeRest = new MenuItem("Change to Rest");
        this.makeRest.addActionListener(this);
        this.noteContextMenu.add(this.makeRest);
        this.deleteNote = new MenuItem("Delete Note");
        this.deleteNote.addActionListener(this);
        this.noteContextMenu.add(this.deleteNote);
        this.theApp.add(this.noteContextMenu);
    }

    boolean inNoteArea(MouseEvent e) {
        Integer lastX = this.theApp.notePositions.size() < 2 ? new Integer(this.theApp.getTotalBeatWidth()) : (Integer)this.theApp.notePositions.elementAt(this.theApp.notePositions.size() - 2);
        return e.getX() <= lastX + 15 && e.getX() < this.theApp.getTotalBeatWidth() + 50;
    }

    private void searchForSelectedNote(MouseEvent e) {
        int i = 0;
        while (i < this.theApp.notePositions.size()) {
            Integer tempX = (Integer)this.theApp.notePositions.elementAt(i);
            Integer tempY = (Integer)this.theApp.notePositions.elementAt(i + 1);
            if (e.getX() > tempX && e.getX() < tempX + 15 && e.getY() + this.theApp.staveDelta > tempY + 22 && e.getY() + this.theApp.staveDelta < tempY + 35) {
                this.selectedNote = i / 2;
                this.clickedPosY = e.getY() + this.theApp.staveDelta;
                this.clickedPosX = e.getX();
                i = this.theApp.notePositions.size();
            }
            i += 2;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 8) != 0 && this.inNoteArea(e)) {
            this.searchForSelectedNote(e);
            if (this.selectedNote >= 0 && this.selectedNote < this.theApp.getPhrase().size()) {
                this.noteContextMenu.show(this.theApp, e.getX(), e.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 8) != 0 || !this.theApp.editable) {
            return;
        }
        this.button1Down = true;
        if (!this.inNoteArea(e)) {
            int newPitch = 85 - (e.getY() + this.theApp.staveDelta - this.theApp.bPos) / 2;
            int[] blackNotes = new int[]{1, 3, 6, 8, 10};
            boolean white = true;
            int k = 0;
            while (k < blackNotes.length) {
                if (newPitch % 12 == blackNotes[k]) {
                    --newPitch;
                }
                ++k;
            }
            Note n = new Note(newPitch, 1.0);
            Phrase phr = this.theApp.getPhrase();
            phr.addNote(n);
            this.theApp.repaint();
            this.theApp.setCursor(new Cursor(12));
            this.selectedNote = phr.size() - 1;
            this.clickedPosY = e.getY() + this.theApp.staveDelta;
            this.clickedPosX = e.getX();
        } else {
            this.searchForSelectedNote(e);
            this.theApp.setCursor(new Cursor(13));
        }
        if (this.selectedNote < 0) {
            int j = 0;
            while (j < this.theApp.notePositions.size() - 2) {
                Integer tempX = (Integer)this.theApp.notePositions.elementAt(j);
                Integer nextTempX = (Integer)this.theApp.notePositions.elementAt(j + 2);
                if (e.getX() > tempX + 15 && e.getX() < nextTempX) {
                    this.theApp.setCursor(new Cursor(12));
                    int newPitch = 85 - (e.getY() + this.theApp.staveDelta - this.theApp.bPos) / 2;
                    int[] blackNotes = new int[]{1, 3, 6, 8, 10};
                    boolean white = true;
                    int k = 0;
                    while (k < blackNotes.length) {
                        if (newPitch % 12 == blackNotes[k]) {
                            --newPitch;
                        }
                        ++k;
                    }
                    Note n = new Note(newPitch, 1.0);
                    Phrase phr = this.theApp.getPhrase();
                    phr.getNoteList().insertElementAt(n, j / 2 + 1);
                    this.theApp.repaint();
                    this.selectedNote = j / 2 + 1;
                    this.clickedPosY = e.getY() + this.theApp.staveDelta;
                    this.clickedPosX = e.getX();
                    j = this.theApp.notePositions.size();
                }
                j += 2;
            }
        }
        int theSpace = this.theApp.rightMargin + this.theApp.clefWidth + this.theApp.keySigWidth;
        if (e.getX() > theSpace && e.getX() < theSpace + 10) {
            this.theApp.setCursor(new Cursor(13));
            this.topTimeSelected = true;
            this.clickedPosY = e.getY() + this.theApp.staveDelta;
            this.clickedPosX = e.getX();
        }
        int theClefSpace = this.theApp.rightMargin + this.theApp.clefWidth;
        int minKeySpace = 10;
        if (this.theApp.keySigWidth > minKeySpace) {
            minKeySpace = this.theApp.keySigWidth;
        }
        if (e.getX() > theClefSpace - 10 && e.getX() < theClefSpace + minKeySpace) {
            this.theApp.setCursor(new Cursor(13));
            this.keySelected = true;
            this.clickedPosY = e.getY() + this.theApp.staveDelta;
            this.clickedPosX = e.getX();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.button1Down || !this.theApp.editable) {
            return;
        }
        if (this.selectedNote >= 0) {
            int i;
            int currRVindex;
            int tempPitch;
            double tempRV;
            Phrase phr = this.theApp.getPhrase();
            Note n = phr.getNote(this.selectedNote);
            if (e.getY() + this.theApp.staveDelta > this.clickedPosY + 2 && this.theApp.getPhrase().getNote(this.selectedNote).getPitch() != Integer.MIN_VALUE) {
                n.setPitch(n.getPitch() - 1);
                if (n.getPitch() < this.theApp.getMinPitch()) {
                    n.setPitch(this.theApp.getMinPitch());
                }
                this.clickedPosY += 2;
                this.theApp.repaint();
                this.storedPitch = n.getPitch();
            }
            if (e.getY() + this.theApp.staveDelta < this.clickedPosY - 2 && this.theApp.getPhrase().getNote(this.selectedNote).getPitch() != Integer.MIN_VALUE) {
                n.setPitch(n.getPitch() + 1);
                if (n.getPitch() > this.theApp.getMaxPitch()) {
                    n.setPitch(this.theApp.getMaxPitch());
                }
                this.clickedPosY -= 2;
                this.theApp.repaint();
                this.storedPitch = n.getPitch();
            }
            if (e.getX() > this.clickedPosX + 6) {
                tempRV = n.getRhythmValue();
                tempPitch = n.getPitch();
                if (tempPitch == Integer.MIN_VALUE) {
                    tempRV += 100.0;
                }
                currRVindex = this.rhythmValues.length;
                i = 0;
                while (i < this.rhythmValues.length - 1) {
                    if (tempRV == this.rhythmValues[i]) {
                        n.setRhythmValue(this.rhythmValues[i + 1]);
                    }
                    ++i;
                }
                this.clickedPosX = e.getX();
                if (n.getRhythmValue() > 100.0) {
                    n.setPitch(Integer.MIN_VALUE);
                    n.setRhythmValue(n.getRhythmValue() - 100.0);
                    n.setDuration(n.getRhythmValue() * 0.9);
                } else if (tempPitch == Integer.MIN_VALUE) {
                    n.setPitch(this.storedPitch);
                }
                this.theApp.repaint();
            }
            if (e.getX() < this.clickedPosX - 6) {
                tempRV = n.getRhythmValue();
                tempPitch = n.getPitch();
                if (tempPitch == Integer.MIN_VALUE) {
                    tempRV += 100.0;
                }
                currRVindex = 0;
                i = 0;
                while (i < this.rhythmValues.length) {
                    if (tempRV == this.rhythmValues[i]) {
                        currRVindex = i;
                    }
                    ++i;
                }
                if (currRVindex > 0) {
                    n.setRhythmValue(this.rhythmValues[currRVindex - 1]);
                    this.clickedPosX = e.getX();
                    if (n.getRhythmValue() > 100.0) {
                        n.setPitch(Integer.MIN_VALUE);
                        n.setRhythmValue(n.getRhythmValue() - 100.0);
                        n.setDuration(n.getRhythmValue() * 0.9);
                    } else if (tempPitch == Integer.MIN_VALUE) {
                        n.setPitch(this.storedPitch);
                    }
                    this.theApp.repaint();
                }
            }
        }
        if (this.topTimeSelected) {
            if (e.getY() + this.theApp.staveDelta < this.clickedPosY - 4) {
                this.theApp.setMetre(this.theApp.getMetre() + 1.0);
                if (this.theApp.getMetre() > 9.0) {
                    this.theApp.setMetre(9.0);
                }
                if (this.theApp.getMetre() < 1.0) {
                    this.theApp.setMetre(1.0);
                }
                this.theApp.getPhrase().setNumerator(new Double(Math.round(this.theApp.getMetre())).intValue());
                this.clickedPosY -= 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
            if (e.getY() + this.theApp.staveDelta > this.clickedPosY + 4) {
                this.theApp.setMetre(this.theApp.getMetre() - 1.0);
                if (this.theApp.getMetre() < 1.0) {
                    this.theApp.setMetre(1.0);
                }
                if (this.theApp.getMetre() > 9.0) {
                    this.theApp.setMetre(9.0);
                }
                this.theApp.getPhrase().setNumerator(new Double(Math.round(this.theApp.getMetre())).intValue());
                this.clickedPosY += 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
        }
        if (this.keySelected) {
            if (e.getY() + this.theApp.staveDelta < this.clickedPosY - 4) {
                this.theApp.setKeySignature(this.theApp.getKeySignature() + 1);
                if (this.theApp.getKeySignature() > 7) {
                    this.theApp.setKeySignature(7);
                }
                this.clickedPosY -= 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
            if (e.getY() + this.theApp.staveDelta > this.clickedPosY + 4) {
                this.theApp.setKeySignature(this.theApp.getKeySignature() - 1);
                if (this.theApp.getKeySignature() < -7) {
                    this.theApp.setKeySignature(-7);
                }
                this.clickedPosY += 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.button1Down = false;
        if (!this.theApp.editable) {
            return;
        }
        int i = 0;
        while (i < this.theApp.getPhrase().getNoteList().size()) {
            if (this.theApp.getPhrase().getNote(i).getRhythmValue() == 0.0) {
                this.theApp.getPhrase().getNoteList().removeElementAt(i);
            }
            ++i;
        }
        this.theApp.repaint();
        this.theApp.updateChange();
        this.selectedNote = -1;
        this.topTimeSelected = false;
        this.keySelected = false;
        this.theApp.setCursor(new Cursor(0));
    }

    public void actionPerformed(ActionEvent e) {
        Phrase phrase = this.theApp.getPhrase();
        Note note = phrase.getNote(this.selectedNote);
        if (e.getSource() == this.editNote) {
            Frame editorFrame = new Frame("Edit this Note");
            ((Component)editorFrame).setSize(400, 400);
            editorFrame.setResizable(true);
            NoteEditor noteEditor = new NoteEditor(editorFrame);
            noteEditor.editNote(note, 20, 20);
        } else if (e.getSource() == this.repeatNote) {
            Note newNote = note.copy();
            phrase.getNoteList().insertElementAt(newNote, this.selectedNote);
        } else if (e.getSource() == this.makeRest) {
            note.setFrequency(-2.147483648E9);
        } else if (e.getSource() == this.deleteNote) {
            phrase.getNoteList().removeElementAt(this.selectedNote);
        }
        this.selectedNote = -1;
        this.theApp.repaint();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\b') {
            this.theApp.deleteLastNote();
        }
    }
}

