/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import jm.JMC;
import jm.gui.cpn.Images;
import jm.gui.cpn.StaveActionHandler;
import jm.gui.cpn.ToolkitImages;
import jm.music.data.Phrase;
import jm.music.tools.Mod;

public abstract class Stave
extends Panel
implements JMC,
KeyListener {
    protected boolean requiresMoreThanOneImage = false;
    protected double excessRhythmValue = 0.0;
    protected boolean isUp = true;
    protected boolean isNote = false;
    public Image image;
    protected Graphics g;
    protected Image trebleClef;
    protected Image bassClef;
    protected Image crotchetUp;
    protected Image crotchetDown;
    protected Image quaverDown;
    protected Image quaverUp;
    protected Image semiquaverDown;
    protected Image semiquaverUp;
    protected Image minimDown;
    protected Image minimUp;
    protected Image semibreve;
    protected Image dot;
    protected Image semiquaverRest;
    protected Image quaverRest;
    protected Image crotchetRest;
    protected Image minimRest;
    protected Image semibreveRest;
    protected Image sharp;
    protected Image flat;
    protected Image natural;
    protected Image one;
    protected Image two;
    protected Image three;
    protected Image four;
    protected Image five;
    protected Image six;
    protected Image seven;
    protected Image eight;
    protected Image nine;
    protected Image delete;
    protected Image tieOver;
    protected Image tieUnder;
    public int staveSpaceHeight = 8;
    public int rightMargin = 20;
    public int beatWidth = 43;
    public int staveWidth = this.beatWidth * 15;
    public int imageHeightOffset = 28;
    public int clefWidth = 38;
    public int timeSigWidth = 5;
    public int keySigWidth = 5;
    public int bPos = 28;
    protected Phrase phrase;
    protected Image currImage;
    protected int currBeatWidth;
    protected int totalBeatWidth;
    protected boolean dottedNote = false;
    protected int[] notePosOffset;
    protected double metre;
    protected int keySignature;
    protected int[] sharps;
    protected int[] flats;
    protected Vector previouslyChromatic;
    protected int[] lineNotes;
    public Vector notePositions;
    protected int maxPitch;
    protected int minPitch;
    protected String title;
    protected boolean barNumbers;
    protected boolean editable;
    protected boolean qtOn;
    protected int panelHeight;
    protected int staveDelta;
    protected boolean displayTitle;
    protected Font font;
    protected int spacingValue;

    public Stave() {
        this(new Phrase(), new ToolkitImages());
    }

    public Stave(Phrase phrase) {
        this(phrase, new ToolkitImages());
    }

    public Stave(Images images) {
        this(new Phrase(), images);
    }

    public Stave(Phrase phr, Images images) {
        int[] nArray = new int[12];
        nArray[0] = 24;
        nArray[1] = 24;
        nArray[2] = 20;
        nArray[3] = 20;
        nArray[4] = 16;
        nArray[5] = 12;
        nArray[6] = 12;
        nArray[7] = 8;
        nArray[8] = 8;
        nArray[9] = 4;
        nArray[10] = 4;
        this.notePosOffset = nArray;
        this.metre = 4.0;
        this.keySignature = 0;
        this.sharps = new int[]{77, 72, 79, 74, 69, 76, 71};
        this.flats = new int[]{71, 76, 69, 74, 67, 72, 65};
        this.previouslyChromatic = new Vector();
        int[] nArray2 = new int[12];
        nArray2[1] = 1;
        nArray2[2] = 4;
        nArray2[3] = 7;
        nArray2[4] = 8;
        nArray2[5] = 11;
        nArray2[6] = 14;
        nArray2[7] = 15;
        nArray2[8] = 17;
        nArray2[9] = 18;
        nArray2[10] = 21;
        nArray2[11] = 22;
        this.lineNotes = nArray2;
        this.notePositions = new Vector();
        this.maxPitch = 127;
        this.minPitch = 0;
        this.barNumbers = false;
        this.editable = true;
        this.qtOn = false;
        this.panelHeight = 110;
        this.staveDelta = 0;
        this.displayTitle = false;
        this.font = new Font("Helvetica", 0, 10);
        this.spacingValue = 70;
        this.title = phr.getTitle();
        this.phrase = this.addRequiredRests(phr);
        this.setBackground(Color.getHSBColor(0.14f, 0.09f, 1.0f));
        this.setSize(this.beatWidth * this.spacingValue, this.panelHeight);
        if (this.getSize().width < (int)(this.phrase.getEndTime() * (double)this.beatWidth * 1.5)) {
            this.setSize((int)(this.phrase.getEndTime() * (double)this.beatWidth * 1.5), this.panelHeight);
        }
        StaveActionHandler handleActions = new StaveActionHandler(this);
        this.addMouseListener(handleActions);
        this.addMouseMotionListener(handleActions);
        this.trebleClef = images.getTrebleClef();
        this.bassClef = images.getBassClef();
        this.crotchetDown = images.getCrotchetDown();
        this.crotchetUp = images.getCrotchetUp();
        this.quaverDown = images.getQuaverDown();
        this.quaverUp = images.getQuaverUp();
        this.semiquaverDown = images.getSemiquaverDown();
        this.semiquaverUp = images.getSemiquaverUp();
        this.minimDown = images.getMinimDown();
        this.minimUp = images.getMinimUp();
        this.semibreve = images.getSemibreve();
        this.dot = images.getDot();
        this.semiquaverRest = images.getSemiquaverRest();
        this.quaverRest = images.getQuaverRest();
        this.crotchetRest = images.getCrotchetRest();
        this.minimRest = images.getMinimRest();
        this.semibreveRest = images.getSemibreveRest();
        this.sharp = images.getSharp();
        this.flat = images.getFlat();
        this.natural = images.getNatural();
        this.one = images.getOne();
        this.two = images.getTwo();
        this.three = images.getThree();
        this.four = images.getFour();
        this.five = images.getFive();
        this.six = images.getSix();
        this.seven = images.getSeven();
        this.eight = images.getEight();
        this.nine = images.getNine();
        this.delete = images.getDelete();
        this.tieOver = images.getTieOver();
        this.tieUnder = images.getTieUnder();
    }

    public Phrase addRequiredRests(Phrase phrase) {
        if (phrase.getStartTime() > 0.0) {
            Phrase tempPhrase = new Phrase(0.0);
            double remTime = phrase.getStartTime();
            while (remTime >= 4.0) {
                tempPhrase.addNote(Integer.MIN_VALUE, 4.0);
                remTime -= 4.0;
            }
            while (remTime >= 1.0) {
                tempPhrase.addNote(Integer.MIN_VALUE, 1.0);
                remTime -= 1.0;
            }
            tempPhrase.addNote(Integer.MIN_VALUE, remTime);
            Mod.append(tempPhrase, phrase);
            phrase = tempPhrase;
        }
        return phrase;
    }

    public void setPhrase(Phrase phr) {
        this.phrase = this.addRequiredRests(phr);
        this.previouslyChromatic.removeAllElements();
        this.repaint();
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.phrase != null) {
            this.phrase.setTitle(title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void removeTitle() {
        this.title = null;
    }

    public void setDisplayTitle(boolean value) {
        this.displayTitle = value;
        this.repaint();
    }

    public boolean getDisplayTitle() {
        return this.displayTitle;
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public void setMetre(double timeSig) {
        this.metre = timeSig;
    }

    public double getMetre() {
        return this.metre;
    }

    public int getMajorKey() {
        int[] nArray = new int[15];
        nArray[0] = 11;
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 8;
        nArray[4] = 3;
        nArray[5] = 10;
        nArray[6] = 5;
        nArray[8] = 7;
        nArray[9] = 2;
        nArray[10] = 9;
        nArray[11] = 4;
        nArray[12] = 11;
        nArray[13] = 6;
        nArray[14] = 1;
        int[] keys = nArray;
        return keys[this.keySignature + 7];
    }

    public void setKeySignature(int key) {
        this.keySignature = key;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setBarNumbers(boolean show) {
        this.barNumbers = show;
    }

    public void setEditable(boolean state) {
        this.editable = state;
    }

    public int getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(int min) {
        this.minPitch = min;
    }

    public int getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(int max) {
        this.maxPitch = max;
    }

    public int getTotalBeatWidth() {
        return this.totalBeatWidth;
    }

    public void setTotalBeatWidth(int width) {
        this.totalBeatWidth = width;
    }

    public boolean getBarNumbers() {
        return this.barNumbers;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public boolean getQtOn() {
        return this.qtOn;
    }

    public void setQtOn(boolean state) {
        this.qtOn = state;
    }

    public void updateChange() {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics graphics) {
    }

    public void deleteLastNote() {
        if (this.phrase.size() > 0) {
            this.phrase.removeNote(this.phrase.size() - 1);
            this.repaint();
            this.updateChange();
        }
    }

    protected void chooseImage(int pitch, double rhythmValue, int upPitch1, int downPitch, int upPitch2) {
        if (pitch == Integer.MIN_VALUE) {
            this.isNote = false;
            if (rhythmValue <= 0.0) {
                this.currImage = this.delete;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else if (rhythmValue <= 0.2501) {
                this.currImage = this.semiquaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else if (rhythmValue <= 0.501) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
            } else if (rhythmValue <= 0.7501) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                this.dottedNote = true;
            } else if (rhythmValue <= 1.001) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
            } else if (rhythmValue <= 1.2501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 1.0;
            } else if (rhythmValue <= 1.501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
            } else if (rhythmValue <= 1.7501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 1.5;
            } else if (rhythmValue <= 2.001) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
            } else if (rhythmValue <= 2.7501) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 2.0;
            } else if (rhythmValue <= 3.001) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
            } else if (rhythmValue <= 3.7501) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 3.0;
            } else if (rhythmValue <= 4.001) {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 4.0;
            }
        } else {
            this.isNote = true;
            if (pitch < upPitch1 && pitch >= downPitch || pitch < upPitch2) {
                this.isUp = true;
                if (rhythmValue <= 0.001) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.2501) {
                    this.currImage = this.semiquaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.501) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                } else if (rhythmValue <= 0.7501) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.001) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                } else if (rhythmValue <= 1.2501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.0;
                } else if (rhythmValue <= 1.501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.7501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.5;
                } else if (rhythmValue <= 2.001) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                } else if (rhythmValue <= 2.7501) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 2.0;
                } else if (rhythmValue <= 3.001) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                } else if (rhythmValue <= 3.7501) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 3.0;
                } else if (rhythmValue <= 4.001) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                } else {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 4.0;
                }
            } else {
                this.isUp = false;
                if (rhythmValue <= 0.001) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.2501) {
                    this.currImage = this.semiquaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.501) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                } else if (rhythmValue <= 0.7501) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.001) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                } else if (rhythmValue <= 1.2501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.0;
                } else if (rhythmValue <= 1.501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.7501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.5;
                } else if (rhythmValue <= 2.001) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                } else if (rhythmValue <= 2.7501) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 2.0;
                } else if (rhythmValue <= 3.001) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                } else if (rhythmValue <= 3.7501) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 3.0;
                } else if (rhythmValue <= 4.001) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                } else {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 4.0;
                }
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        System.out.println(e.getKeyChar());
    }
}

