/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import jm.music.data.Note;

public class NoteEditor
extends Dialog
implements ActionListener,
WindowListener {
    private Button okButton = new Button("Apply");
    private Button cancelButton = new Button("Cancel");
    private Note note;
    private List noteList;
    private List octaveList;
    private TextField durationEdit = new TextField(15);
    private TextField dynamicEdit = new TextField(15);
    private TextField rhythmEdit = new TextField(15);
    private TextField panEdit = new TextField(15);
    private TextField offsetEdit = new TextField(15);
    private Label noteLabel = new Label("Note");
    private Label dynamicLabel = new Label("Volume (1-127)");
    private Label rhythmLabel = new Label("Rhythm Value");
    private Label durationLabel = new Label("Duration Factor");
    private Label panLabel = new Label("Pan");
    private Label offsetLabel = new Label("Offset");
    private Label octaveLabel = new Label("Octave");
    private static DecimalFormat decimalFormat = new DecimalFormat("###.###########");

    public NoteEditor(Frame parentFrame) {
        super(parentFrame, "Edit Note", true);
        this.initializeLists();
        this.placeControls();
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(this);
        ((Component)this).setVisible(false);
        this.pack();
    }

    private static String getOctaveStringValue(int pitch) {
        int octave = -1;
        int note = pitch;
        while (note > 11) {
            ++octave;
            note -= 12;
        }
        return new Integer(octave).toString();
    }

    private static String getPitchStringValue(int pitch) {
        if (pitch == Integer.MIN_VALUE) {
            return "Rest";
        }
        int k = pitch;
        while (k >= 12) {
            k -= 12;
        }
        switch (k) {
            case 0: {
                return "C";
            }
            case 1: {
                return "C#";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "D#";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "F#";
            }
            case 7: {
                return "G";
            }
            case 8: {
                return "G#";
            }
            case 9: {
                return "A";
            }
            case 10: {
                return "A#";
            }
            case 11: {
                return "B";
            }
        }
        return "Rest";
    }

    private static void setListToMatch(List list, String valueWanted) {
        int i = list.getItemCount() - 1;
        while (i >= 0) {
            if (list.getItem(i).equals(valueWanted)) {
                list.select(i);
            }
            --i;
        }
    }

    private void initializeNoteListValue(int pitch) {
        NoteEditor.setListToMatch(this.noteList, NoteEditor.getPitchStringValue(pitch));
    }

    private void initializeOctaveListValue(int pitch) {
        NoteEditor.setListToMatch(this.octaveList, NoteEditor.getOctaveStringValue(pitch));
    }

    private static void initializeDoubleEdit(TextField theEdit, double theValue) {
        theEdit.setText(decimalFormat.format(theValue));
    }

    private static void initializeIntEdit(TextField theEdit, int theValue) {
        theEdit.setText(new Integer(theValue).toString());
    }

    private void initializeData() {
        this.initializeNoteListValue(this.note.getPitch());
        this.initializeOctaveListValue(this.note.getPitch());
        NoteEditor.initializeDoubleEdit(this.durationEdit, this.note.getDuration() / this.note.getRhythmValue());
        NoteEditor.initializeDoubleEdit(this.rhythmEdit, this.note.getRhythmValue());
        NoteEditor.initializeDoubleEdit(this.offsetEdit, this.note.getOffset());
        NoteEditor.initializeDoubleEdit(this.panEdit, this.note.getPan());
        NoteEditor.initializeIntEdit(this.dynamicEdit, this.note.getDynamic());
    }

    public void editNote(Note theNote, int locX, int locY) {
        this.note = theNote;
        ((Component)this).setLocation(locX, locY);
        this.initializeData();
        this.show();
    }

    private void initializeLists() {
        this.noteList = new List(6);
        this.noteList.add("Rest");
        this.noteList.add("A");
        this.noteList.add("A#");
        this.noteList.add("B");
        this.noteList.add("C");
        this.noteList.add("C#");
        this.noteList.add("D");
        this.noteList.add("D#");
        this.noteList.add("E");
        this.noteList.add("F");
        this.noteList.add("F#");
        this.noteList.add("G");
        this.noteList.add("G#");
        this.octaveList = new List(6);
        this.octaveList.add("-1");
        this.octaveList.add("0");
        this.octaveList.add("1");
        this.octaveList.add("2");
        this.octaveList.add("3");
        this.octaveList.add("4");
        this.octaveList.add("5");
        this.octaveList.add("6");
        this.octaveList.add("7");
        this.octaveList.add("8");
        this.octaveList.add("9");
    }

    private static boolean validateFloatEdit(TextField theField, double minValue, double maxValue) {
        StringTokenizer fieldTokenizer = new StringTokenizer(theField.getText());
        if (!fieldTokenizer.hasMoreElements()) {
            theField.setText("Error--No Data");
            return false;
        }
        String fieldString = fieldTokenizer.nextToken();
        try {
            double fieldValue = new Double(fieldString);
            if (fieldValue < minValue) {
                theField.setText("Value Too Low");
                return false;
            }
            if (fieldValue < minValue) {
                theField.setText("Value Too High");
                return false;
            }
        }
        catch (Throwable e) {
            theField.setText("Data Error");
            return false;
        }
        if (fieldTokenizer.hasMoreElements()) {
            theField.setText("Data Error");
            return false;
        }
        return true;
    }

    private static double getFieldDouble(TextField theField) {
        StringTokenizer fieldTokenizer = new StringTokenizer(theField.getText());
        String fieldString = fieldTokenizer.nextToken();
        return new Double(fieldString);
    }

    private static boolean validateIntegerEdit(TextField theField, int minValue, int maxValue) {
        StringTokenizer fieldTokenizer = new StringTokenizer(theField.getText());
        if (!fieldTokenizer.hasMoreElements()) {
            theField.setText("Error--No Data");
            return false;
        }
        String fieldString = fieldTokenizer.nextToken();
        try {
            int fieldValue = new Integer(fieldString);
            if (fieldValue < minValue) {
                theField.setText("Value Too Low");
                return false;
            }
            if (fieldValue > maxValue) {
                theField.setText("Value Too High");
                return false;
            }
        }
        catch (Throwable e) {
            theField.setText("Data Error");
            return false;
        }
        if (fieldTokenizer.hasMoreElements()) {
            theField.setText("Data Error");
            return false;
        }
        return true;
    }

    private static int getFieldInt(TextField theField) {
        StringTokenizer fieldTokenizer = new StringTokenizer(theField.getText());
        String fieldString = fieldTokenizer.nextToken();
        return new Integer(fieldString);
    }

    private boolean inputIsValid() {
        return NoteEditor.validateFloatEdit(this.durationEdit, 0.0, 1.0) && NoteEditor.validateIntegerEdit(this.dynamicEdit, 0, 127) && NoteEditor.validateFloatEdit(this.rhythmEdit, 1.0E-5, 64.0) && NoteEditor.validateFloatEdit(this.panEdit, 0.0, 1.0) && NoteEditor.validateFloatEdit(this.offsetEdit, -999.999, 999.999);
    }

    private void placeControls() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        c.fill = 1;
        c.weightx = 0.5;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        layout.setConstraints(this.noteLabel, c);
        this.add(this.noteLabel);
        c.gridx = 0;
        c.gridy = 2;
        c.gridheight = 4;
        layout.setConstraints(this.noteList, c);
        this.add(this.noteList);
        c.gridx = 0;
        c.gridy = 7;
        c.gridheight = 1;
        layout.setConstraints(this.octaveLabel, c);
        this.add(this.octaveLabel);
        c.gridx = 0;
        c.gridy = 8;
        c.gridheight = 4;
        layout.setConstraints(this.octaveList, c);
        this.add(this.octaveList);
        c.gridx = 0;
        c.gridy = 15;
        c.gridheight = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.rhythmLabel, c);
        this.add(this.rhythmLabel);
        c.gridx = 1;
        layout.setConstraints(this.rhythmEdit, c);
        this.add(this.rhythmEdit);
        c.gridx = 0;
        c.gridy = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.dynamicLabel, c);
        this.add(this.dynamicLabel);
        c.gridx = 1;
        layout.setConstraints(this.dynamicEdit, c);
        this.add(this.dynamicEdit);
        c.gridx = 0;
        c.gridy = 19;
        c.gridheight = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.durationLabel, c);
        this.add(this.durationLabel);
        c.gridx = 1;
        layout.setConstraints(this.durationEdit, c);
        this.add(this.durationEdit);
        c.gridx = 0;
        c.gridy = 21;
        c.gridheight = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.offsetLabel, c);
        this.add(this.offsetLabel);
        c.gridx = 1;
        layout.setConstraints(this.offsetEdit, c);
        this.add(this.offsetEdit);
        c.gridx = 0;
        c.gridy = 23;
        c.gridheight = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.panLabel, c);
        this.add(this.panLabel);
        c.gridx = 1;
        layout.setConstraints(this.panEdit, c);
        this.add(this.panEdit);
        c.gridx = 0;
        c.gridy = 25;
        c.gridheight = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.okButton, c);
        this.add(this.okButton);
        c.gridx = 1;
        layout.setConstraints(this.cancelButton, c);
        this.add(this.cancelButton);
    }

    private int getSelectedPitch() {
        String noteString = this.noteList.getSelectedItem();
        if (noteString.equals("Rest")) {
            return Integer.MIN_VALUE;
        }
        int answer = noteString.equals("C") ? 0 : (noteString.equals("C#") ? 1 : (noteString.equals("D") ? 2 : (noteString.equals("D#") ? 3 : (noteString.equals("E") ? 4 : (noteString.equals("F") ? 5 : (noteString.equals("F#") ? 6 : (noteString.equals("G") ? 7 : (noteString.equals("G#") ? 8 : (noteString.equals("A") ? 9 : (noteString.equals("A#") ? 10 : (noteString.equals("A") ? 11 : 0)))))))))));
        int octave = new Integer(this.octaveList.getSelectedItem());
        while (octave > -1) {
            answer += 12;
            --octave;
        }
        return answer;
    }

    private void updateTheNote() {
        this.note.setPitch(this.getSelectedPitch());
        this.note.setRhythmValue(NoteEditor.getFieldDouble(this.rhythmEdit));
        this.note.setDuration(this.note.getRhythmValue() * NoteEditor.getFieldDouble(this.durationEdit));
        this.note.setDynamic(NoteEditor.getFieldInt(this.dynamicEdit));
        this.note.setPan(NoteEditor.getFieldDouble(this.panEdit));
        this.note.setOffset(NoteEditor.getFieldDouble(this.offsetEdit));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.inputIsValid()) {
                this.updateTheNote();
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

