/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.sound.midi.MidiUnavailableException;
import jm.gui.cpn.JmMidiPlayer;
import jm.gui.cpn.Stave;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Write;

public class LetterNotesEditor
extends Dialog
implements ActionListener,
WindowListener {
    private Button okButton;
    private Button playButton;
    private Button cancelButton;
    private Button copyButton;
    private Label inputLabel;
    private TextArea notesInput;
    private Phrase phrase;
    private Stave stave;
    private Note currentNote;
    private char currentNoteLetter = (char)65;
    private int currentPitch = 69;
    private static List inputList = new List(8);

    public LetterNotesEditor(Frame parentFrame) {
        super(parentFrame, "Set Music Parameters", true);
        this.initializeData();
        this.initializeButtons();
        this.initializeLabels();
        ((Component)this).setSize(500, 300);
        this.placeControls();
        this.addWindowListener(this);
        ((Component)this).setVisible(false);
        this.pack();
    }

    private void initializeData() {
        this.notesInput = new TextArea("", 10, 100, 0);
    }

    private void initializeButtons() {
        this.okButton = new Button("Add Notes");
        this.playButton = new Button("Play Notes");
        this.cancelButton = new Button("Cancel");
        this.copyButton = new Button("Copy");
    }

    private void initializeLabels() {
        this.inputLabel = new Label("Enter Note Names, R for Rest");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.addNotes();
            this.dispose();
        } else if (e.getSource() == this.playButton) {
            this.playNotes();
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.copyButton && inputList.getSelectedItem().length() > 0) {
            this.notesInput.setText(inputList.getSelectedItem());
        }
    }

    private void addNotes() {
        this.initializeUpdate();
        String s = this.notesInput.getText();
        int i = 0;
        while (i < s.length()) {
            this.processChar(Character.toUpperCase(s.charAt(i)));
            ++i;
        }
        inputList.add(LetterNotesEditor.crunchLine(s), 0);
        while (inputList.getItemCount() > 100) {
            inputList.remove(100);
        }
    }

    private void playNotes() {
        Phrase savePhrase = this.phrase.copy();
        this.initializeUpdate();
        String s = this.notesInput.getText();
        int i = 0;
        while (i < s.length()) {
            this.processChar(Character.toUpperCase(s.charAt(i)));
            ++i;
        }
        i = 0;
        while (i < savePhrase.size()) {
            this.phrase.removeNote(0);
            ++i;
        }
        try {
            JmMidiPlayer midiPlayer = new JmMidiPlayer();
            Score sc = new Score();
            Part p = new Part();
            sc.addPart(p);
            p.addPhrase(this.phrase);
            Write.midi(sc, midiPlayer);
            midiPlayer.play();
            midiPlayer.close();
        }
        catch (MidiUnavailableException ex) {
            System.out.println("Midi Not Available");
        }
        this.phrase.empty();
        i = 0;
        while (i < savePhrase.size()) {
            this.phrase.addNote(savePhrase.getNote(i));
            ++i;
        }
    }

    private void initializeUpdate() {
        if (this.phrase.size() > 0) {
            this.currentNote = this.phrase.getNote(this.phrase.size() - 1);
            if (this.currentNote.getPitch() >= 0) {
                this.currentPitch = this.currentNote.getPitch();
                this.currentNoteLetter = LetterNotesEditor.getNoteLetter(this.currentPitch, this.stave.getKeySignature());
            }
        } else {
            this.currentNote = null;
        }
    }

    private static char getNoteLetter(int pitch, int keySignature) {
        int notePos = pitch % 12;
        switch (notePos) {
            case 0: {
                return 'C';
            }
            case 2: {
                return 'D';
            }
            case 4: {
                return 'E';
            }
            case 5: {
                return 'F';
            }
            case 7: {
                return 'G';
            }
            case 9: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
        }
        if (keySignature >= 0) {
            return LetterNotesEditor.getNoteLetter(pitch - 1, keySignature);
        }
        return LetterNotesEditor.getNoteLetter(pitch + 1, keySignature);
    }

    private void processChar(char c) {
        switch (c) {
            case 'A': {
                this.addNote(69, c);
                break;
            }
            case 'B': {
                this.addNote(71, c);
                break;
            }
            case 'C': {
                this.addNote(60, c);
                break;
            }
            case 'D': {
                this.addNote(62, c);
                break;
            }
            case 'E': {
                this.addNote(64, c);
                break;
            }
            case 'F': {
                this.addNote(65, c);
                break;
            }
            case 'G': {
                this.addNote(67, c);
                break;
            }
            case 'R': {
                this.addNote(Integer.MIN_VALUE, c);
                break;
            }
            case '#': 
            case '+': {
                this.sharpenNote();
                break;
            }
            case '-': {
                this.flattenNote();
                break;
            }
            case '>': {
                this.addOctave();
                break;
            }
            case '<': {
                this.subtractOctave();
                break;
            }
            case '1': {
                this.moveToInterval(23, 36);
                break;
            }
            case '2': {
                this.moveToInterval(35, 48);
                break;
            }
            case '3': {
                this.moveToInterval(47, 60);
                break;
            }
            case '4': {
                this.moveToInterval(59, 72);
                break;
            }
            case '5': {
                this.moveToInterval(71, 84);
                break;
            }
            case '6': {
                this.moveToInterval(83, 96);
                break;
            }
            case '7': {
                this.moveToInterval(95, 108);
                break;
            }
            case '8': {
                this.moveToInterval(107, 120);
                break;
            }
            case '9': {
                this.moveToInterval(119, 127);
                break;
            }
            case '.': {
                this.dotNote();
                break;
            }
            case 'H': {
                this.makeHalfNote();
                break;
            }
            case 'W': {
                this.makeWholeNote();
                break;
            }
            case 'Q': {
                this.makeQuarterNote();
                break;
            }
            case 'N': {
                this.makeEighthNote();
                break;
            }
            case 'T': {
                this.makeTriplet();
                break;
            }
            case 'X': {
                this.makeSixteenthNote();
                break;
            }
            case '&': {
                this.tieNotes();
                break;
            }
        }
    }

    static boolean pitchIsHigh(int pitchValue, int currentPitch, char letterValue, char currentLetter) {
        String notesString = "ABCDEFGABCDEFG";
        if (pitchValue > currentPitch + 8) {
            return true;
        }
        if (pitchValue < currentPitch + 3) {
            return false;
        }
        int i = notesString.indexOf(currentLetter);
        int j = notesString.indexOf(letterValue, i);
        return j > i + 3;
    }

    static boolean pitchIsLow(int pitchValue, int currentPitch, char letterValue, char currentLetter) {
        String notesString = "ABCDEFGABCDEFG";
        if (pitchValue < currentPitch - 8) {
            return true;
        }
        if (pitchValue > currentPitch - 3) {
            return false;
        }
        int i = notesString.indexOf(letterValue);
        int j = notesString.indexOf(currentLetter, i);
        return j > i + 3;
    }

    /*
     * Unable to fully structure code
     */
    private void addNote(int pitchValue, char charValue) {
        block5: {
            pv = pitchValue;
            newNote = this.currentNote != null ? this.currentNote.copy() : new Note();
            if (charValue == 'R') break block5;
            if (pv <= this.currentPitch) ** GOTO lbl10
            while (LetterNotesEditor.pitchIsHigh(pv, this.currentPitch, charValue, this.currentNoteLetter)) {
                pv -= 12;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                pv += 12;
lbl10:
                // 2 sources

                ** while (LetterNotesEditor.pitchIsLow((int)pv, (int)this.currentPitch, (char)charValue, (char)this.currentNoteLetter))
            }
        }
        if (this.noteIsSharp(charValue)) {
            ++pv;
        }
        if (this.noteIsFlat(charValue)) {
            --pv;
        }
        newNote.setPitch(pv);
        this.phrase.add(newNote);
        this.currentNote = newNote;
        this.currentNoteLetter = charValue;
        if (this.currentNoteLetter != 'R') {
            this.currentPitch = pv;
        }
    }

    private void sharpenNote() {
        this.currentNote.setPitch(this.currentNote.getPitch() + 1);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void flattenNote() {
        this.currentNote.setPitch(this.currentNote.getPitch() - 1);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void addOctave() {
        this.currentNote.setPitch(this.currentNote.getPitch() + 12);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void subtractOctave() {
        this.currentNote.setPitch(this.currentNote.getPitch() - 12);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void moveToInterval(int from, int thru) {
        while (this.currentNote.getPitch() > thru) {
            this.currentNote.setPitch(this.currentNote.getPitch() - 12);
        }
        while (this.currentNote.getPitch() < from) {
            this.currentNote.setPitch(this.currentNote.getPitch() + 12);
        }
        if (this.currentNote.getPitch() == from && this.currentNoteLetter == 'B') {
            this.currentNote.setPitch(this.currentNote.getPitch() + 12);
        }
        if (this.currentNote.getPitch() == thru && this.currentNoteLetter == 'C') {
            this.currentNote.setPitch(this.currentNote.getPitch() - 12);
        }
        this.currentPitch = this.currentNote.getPitch();
    }

    private void dotNote() {
        this.adjustNoteByFactor(1.5);
    }

    private void makeHalfNote() {
        this.adjustNoteByFactor(2.0 / this.currentNote.getRhythmValue());
    }

    private void makeWholeNote() {
        this.adjustNoteByFactor(4.0 / this.currentNote.getRhythmValue());
    }

    private void makeQuarterNote() {
        this.adjustNoteByFactor(1.0 / this.currentNote.getRhythmValue());
    }

    private void makeEighthNote() {
        this.adjustNoteByFactor(0.5 / this.currentNote.getRhythmValue());
    }

    private void makeTriplet() {
        this.adjustNoteByFactor(0.3333333333333333 / this.currentNote.getRhythmValue());
    }

    private void makeSixteenthNote() {
        this.adjustNoteByFactor(0.25 / this.currentNote.getRhythmValue());
    }

    private void tieNotes() {
        if (this.phrase.size() > 1) {
            this.phrase.removeLastNote();
            Note lastNote = this.phrase.getNote(this.phrase.size() - 1);
            lastNote.setDuration(lastNote.getDuration() + this.currentNote.getDuration());
            lastNote.setRhythmValue(lastNote.getRhythmValue() + this.currentNote.getRhythmValue());
            this.currentNote = lastNote;
        }
    }

    private boolean noteIsSharp(char charValue) {
        String sharpNotes = "FCGDAEB";
        int numSharps = this.stave.getKeySignature();
        boolean answer = charValue == 'R' ? false : (numSharps > 0 ? sharpNotes.indexOf(charValue) < numSharps : false);
        return answer;
    }

    private boolean noteIsFlat(char charValue) {
        String flatNotes = "BEADGCF";
        int numFlats = -this.stave.getKeySignature();
        boolean answer = charValue == 'R' ? false : (numFlats > 0 ? flatNotes.indexOf(charValue) < numFlats : false);
        return answer;
    }

    private void adjustNoteByFactor(double x) {
        this.currentNote.setRhythmValue(x * this.currentNote.getRhythmValue());
        this.currentNote.setDuration(x * this.currentNote.getDuration());
    }

    private void placeControls() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        c.fill = 1;
        c.weightx = 0.5;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        layout.setConstraints(this.inputLabel, c);
        this.add(this.inputLabel);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 10;
        layout.setConstraints(this.notesInput, c);
        this.add(this.notesInput);
        c.gridx = 2;
        c.gridy = 12;
        c.gridheight = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.okButton, c);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        c.gridx = 3;
        c.gridy = 12;
        c.gridwidth = 1;
        layout.setConstraints(this.playButton, c);
        this.add(this.playButton);
        this.playButton.addActionListener(this);
        c.gridx = 4;
        c.gridy = 12;
        c.gridwidth = 1;
        layout.setConstraints(this.cancelButton, c);
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        c.gridx = 1;
        c.gridy = 15;
        c.gridwidth = 5;
        c.gridheight = 5;
        layout.setConstraints(inputList, c);
        this.add(inputList);
        c.gridx = 1;
        c.gridy = 20;
        c.gridwidth = 5;
        c.gridheight = 1;
        layout.setConstraints(this.copyButton, c);
        this.add(this.copyButton);
        this.copyButton.addActionListener(this);
    }

    public void getNotes(Stave theStave) {
        this.phrase = theStave.getPhrase();
        this.stave = theStave;
        ((Component)this).setLocation(200, 50);
        this.show();
    }

    private static String crunchLine(String s) {
        StringBuffer b = new StringBuffer(s);
        int i = 0;
        while (i < b.length()) {
            if (b.charAt(i) < ' ') {
                b.setCharAt(i, ' ');
            }
            ++i;
        }
        i = 0;
        while (i < b.length() - 1) {
            if (b.charAt(i) == ' ') {
                if (b.charAt(i + 1) == ' ') {
                    b.deleteCharAt(i);
                    continue;
                }
                i += 2;
                continue;
            }
            ++i;
        }
        return b.toString();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

