/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;

public class JmMidiPlayer
extends OutputStream {
    private Sequencer sequencer = MidiSystem.getSequencer();
    private Transmitter transmitter;
    private Receiver receiver;
    private MidiDevice synthesizer = JmMidiPlayer.getSynthesizer();
    ByteArrayOutputStream os;

    private static MidiDevice getSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info[] devsInfo = MidiSystem.getMidiDeviceInfo();
        MidiDevice dev = null;
        boolean success = false;
        int i = 0;
        while (i < devsInfo.length) {
            if (!success) {
                try {
                    MidiDevice.Info devInfo = devsInfo[i - 1];
                    System.out.print(devInfo.toString());
                    System.out.print(" Getting Info ");
                    dev = MidiSystem.getMidiDevice(devInfo);
                    if (!(dev instanceof Sequencer)) {
                        System.out.print(" Opening ");
                        success = true;
                        System.out.println(" Opened");
                    } else {
                        System.out.println(" Not a Sequencer");
                    }
                }
                catch (Throwable e) {
                    System.out.println(" Exception " + e.getMessage());
                }
            }
            ++i;
        }
        if (success) {
            return dev;
        }
        System.out.println("No Synthesizer Device Found");
        throw new MidiUnavailableException("No Synthesizer Device Found");
    }

    public JmMidiPlayer() throws MidiUnavailableException {
        this.transmitter = this.sequencer.getTransmitter();
        this.receiver = this.synthesizer.getReceiver();
        this.transmitter.setReceiver(this.receiver);
        this.sequencer.open();
        this.sequencer.isOpen();
        this.os = new ByteArrayOutputStream();
        MidiDevice.Info synthInfo = this.synthesizer.getDeviceInfo();
        MidiDevice.Info seqInfo = this.sequencer.getDeviceInfo();
        MidiDevice.Info[] devsInfo = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < devsInfo.length) {
            MidiDevice.Info devInfo = devsInfo[i];
            System.out.print(devInfo.toString());
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(devInfo);
            }
            catch (MidiUnavailableException e) {
                System.out.println(" Unavailable");
            }
            ++i;
        }
        this.sequencer.isOpen();
    }

    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{new Integer(b).byteValue()};
        this.write(bytes);
    }

    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    public void play() {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.os.toByteArray());
            Sequence midiSeq = MidiSystem.getSequence(is);
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            this.sequencer.setSequence(midiSeq);
            this.sequencer.start();
            while (this.sequencer.isRunning()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.sequencer.stop();
        }
        catch (InvalidMidiDataException e) {
            System.out.println("Bad Midi Data " + e.getMessage());
        }
        catch (MidiUnavailableException e) {
            System.out.println("Unable to Re-Open Sequencer " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("IO Exception in Midi " + e.getMessage());
        }
    }

    public void close() {
        this.sequencer.close();
    }
}

