/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Vector;
import javax.swing.JPanel;
import jm.JMC;
import jm.constants.Scales;
import jm.gui.cpn.JStaveActionHandler;
import jm.gui.cpn.KeyChangeListener;
import jm.music.data.Phrase;
import jm.music.tools.ChordAnalysis;
import jm.music.tools.PhraseAnalysis;

public class JGrandStave
extends JPanel
implements JMC {
    private int tonic = 0;
    RGBImageFilter filter = new RGBImageFilter(){
        {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb | 0xFFFF0000;
        }
    };
    public static final int[] keys;
    protected int[] scale = Scales.MAJOR_SCALE;
    private boolean isNormalColor = true;
    protected KeyChangeListener keyChangeListener = null;
    public Image image;
    protected Graphics g;
    protected RedFilter crotchetUp = new RedFilter();
    protected RedFilter crotchetDown = new RedFilter();
    protected RedFilter quaverDown = new RedFilter();
    protected RedFilter quaverUp = new RedFilter();
    protected RedFilter semiquaverDown = new RedFilter();
    protected RedFilter semiquaverUp = new RedFilter();
    protected RedFilter minimDown = new RedFilter();
    protected RedFilter minimUp = new RedFilter();
    protected RedFilter semibreve = new RedFilter();
    protected RedFilter dot = new RedFilter();
    protected RedFilter semiquaverRest = new RedFilter();
    protected RedFilter quaverRest = new RedFilter();
    protected RedFilter crotchetRest = new RedFilter();
    protected RedFilter minimRest = new RedFilter();
    protected RedFilter semibreveRest = new RedFilter();
    protected RedFilter sharp = new RedFilter();
    protected RedFilter flat = new RedFilter();
    protected RedFilter natural = new RedFilter();
    protected RedFilter delete = new RedFilter();
    protected RedFilter tie;
    protected Image trebleClef;
    protected Image bassClef;
    protected Image one;
    protected Image two;
    protected Image three;
    protected Image four;
    protected Image five;
    protected Image six;
    protected Image seven;
    protected Image eight;
    protected Image nine;
    public int staveSpaceHeight;
    public int rightMargin;
    public int beatWidth;
    public int staveWidth;
    public int imageHeightOffset;
    public int clefWidth;
    public int timeSigWidth;
    public int keySigWidth;
    public int bPos;
    protected Phrase phrase;
    protected RedFilter currImage;
    protected int currBeatWidth;
    protected int totalBeatWidth;
    protected boolean dottedNote;
    protected int[] notePosOffset;
    protected double metre;
    protected int keySignature;
    protected int[] sharps;
    protected int[] flats;
    protected Vector previouslyChromatic;
    protected int[] lineNotes;
    public Vector notePositions;
    protected int maxPitch;
    protected int minPitch;
    protected String title;
    protected boolean barNumbers;
    protected boolean editable;
    protected boolean qtOn;
    protected int panelHeight;
    protected int staveDelta;
    public static final int MAX_HEIGHT = 500;
    public static final int MAX_WIDTH = 2000;
    private double beatCounter;
    private boolean isFirstNoteInTie;
    private boolean isNote;
    private boolean firstAccidentalDisplayed;
    private boolean isTied;
    private boolean isUp;
    private boolean semitoneShiftUp;
    private boolean extraImagesUsed;
    private boolean requiresMoreThanOneImage;
    private double excessRhythmValue;
    private int savedBeatWidth;
    private int savedBeatWidth2;
    private int lastChordDisplayed;
    private int lastPosition;
    private int[] firstChords;
    private int[] secondChords;
    private String[] chordStrings;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[15];
        nArray[0] = 11;
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 8;
        nArray[4] = 3;
        nArray[5] = 10;
        nArray[6] = 5;
        nArray[8] = 7;
        nArray[9] = 2;
        nArray[10] = 9;
        nArray[11] = 4;
        nArray[12] = 11;
        nArray[13] = 6;
        nArray[14] = 1;
        keys = nArray;
    }

    public JGrandStave() {
        this(new Phrase());
        this.bPos = 110;
        this.panelHeight = 310;
        this.setSize(this.beatWidth * 40, this.panelHeight);
    }

    public JGrandStave(Phrase phrase) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jm.gui.cpn.Stave");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tie = new RedFilter(toolkit.getImage(clazz.getResource("graphics/tie.gif")));
        this.staveSpaceHeight = 8;
        this.rightMargin = 20;
        this.beatWidth = 43;
        this.staveWidth = this.beatWidth * 15;
        this.imageHeightOffset = 28;
        this.clefWidth = 38;
        this.timeSigWidth = 5;
        this.keySigWidth = 5;
        this.bPos = 28;
        this.dottedNote = false;
        int[] nArray = new int[12];
        nArray[0] = 24;
        nArray[1] = 24;
        nArray[2] = 20;
        nArray[3] = 20;
        nArray[4] = 16;
        nArray[5] = 12;
        nArray[6] = 12;
        nArray[7] = 8;
        nArray[8] = 8;
        nArray[9] = 4;
        nArray[10] = 4;
        this.notePosOffset = nArray;
        this.metre = 4.0;
        this.keySignature = 0;
        this.sharps = new int[]{77, 72, 79, 74, 69, 76, 71};
        this.flats = new int[]{71, 76, 69, 74, 67, 72, 65};
        this.previouslyChromatic = new Vector();
        int[] nArray2 = new int[12];
        nArray2[1] = 1;
        nArray2[2] = 4;
        nArray2[3] = 7;
        nArray2[4] = 8;
        nArray2[5] = 11;
        nArray2[6] = 14;
        nArray2[7] = 15;
        nArray2[8] = 17;
        nArray2[9] = 18;
        nArray2[10] = 21;
        nArray2[11] = 22;
        this.lineNotes = nArray2;
        this.notePositions = new Vector();
        this.maxPitch = 127;
        this.minPitch = 0;
        this.barNumbers = false;
        this.editable = true;
        this.qtOn = false;
        this.panelHeight = 110;
        this.staveDelta = 0;
        this.isFirstNoteInTie = true;
        this.isNote = false;
        this.firstAccidentalDisplayed = false;
        this.isTied = false;
        this.isUp = true;
        this.semitoneShiftUp = false;
        this.lastChordDisplayed = -1;
        this.lastPosition = 0;
        this.firstChords = new int[0];
        this.secondChords = new int[0];
        this.chordStrings = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "."};
        this.phrase = phrase;
        this.title = phrase.getTitle();
        this.setBackground(Color.getHSBColor(0.14f, 0.09f, 1.0f));
        this.setSize(this.beatWidth * 40, this.panelHeight);
        if (this.getSize().width < (int)(phrase.getEndTime() * (double)this.beatWidth * 1.5)) {
            this.setSize((int)(phrase.getEndTime() * (double)this.beatWidth * 1.5), this.panelHeight);
        }
        JStaveActionHandler handleActions = new JStaveActionHandler(this);
        this.addMouseListener(handleActions);
        this.addMouseMotionListener(handleActions);
        try {
            Toolkit toolkit2 = Toolkit.getDefaultToolkit();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.trebleClef = toolkit2.getImage(clazz2.getResource("graphics/trebleClef.gif"));
            Toolkit toolkit3 = Toolkit.getDefaultToolkit();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.bassClef = toolkit3.getImage(clazz3.getResource("graphics/bassClef.gif"));
            Toolkit toolkit4 = Toolkit.getDefaultToolkit();
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.crotchetDown.image = toolkit4.getImage(clazz4.getResource("graphics/crotchetDown.gif"));
            Toolkit toolkit5 = Toolkit.getDefaultToolkit();
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.crotchetUp.image = toolkit5.getImage(clazz5.getResource("graphics/crotchetUp.gif"));
            Toolkit toolkit6 = Toolkit.getDefaultToolkit();
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.quaverDown.image = toolkit6.getImage(clazz6.getResource("graphics/quaverDown.gif"));
            Toolkit toolkit7 = Toolkit.getDefaultToolkit();
            Class<?> clazz7 = class$0;
            if (clazz7 == null) {
                try {
                    clazz7 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.quaverUp.image = toolkit7.getImage(clazz7.getResource("graphics/quaverUp.gif"));
            Toolkit toolkit8 = Toolkit.getDefaultToolkit();
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.semiquaverDown.image = toolkit8.getImage(clazz8.getResource("graphics/semiquaverDown.gif"));
            Toolkit toolkit9 = Toolkit.getDefaultToolkit();
            Class<?> clazz9 = class$0;
            if (clazz9 == null) {
                try {
                    clazz9 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.semiquaverUp.image = toolkit9.getImage(clazz9.getResource("graphics/semiquaverUp.gif"));
            Toolkit toolkit10 = Toolkit.getDefaultToolkit();
            Class<?> clazz10 = class$0;
            if (clazz10 == null) {
                try {
                    clazz10 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.minimDown.image = toolkit10.getImage(clazz10.getResource("graphics/minimDown.gif"));
            Toolkit toolkit11 = Toolkit.getDefaultToolkit();
            Class<?> clazz11 = class$0;
            if (clazz11 == null) {
                try {
                    clazz11 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.minimUp.image = toolkit11.getImage(clazz11.getResource("graphics/minimUp.gif"));
            Toolkit toolkit12 = Toolkit.getDefaultToolkit();
            Class<?> clazz12 = class$0;
            if (clazz12 == null) {
                try {
                    clazz12 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.semibreve.image = toolkit12.getImage(clazz12.getResource("graphics/semibreve.gif"));
            Toolkit toolkit13 = Toolkit.getDefaultToolkit();
            Class<?> clazz13 = class$0;
            if (clazz13 == null) {
                try {
                    clazz13 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.dot.image = toolkit13.getImage(clazz13.getResource("graphics/dot.gif"));
            Toolkit toolkit14 = Toolkit.getDefaultToolkit();
            Class<?> clazz14 = class$0;
            if (clazz14 == null) {
                try {
                    clazz14 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.semiquaverRest.image = toolkit14.getImage(clazz14.getResource("graphics/semiquaverRest.gif"));
            Toolkit toolkit15 = Toolkit.getDefaultToolkit();
            Class<?> clazz15 = class$0;
            if (clazz15 == null) {
                try {
                    clazz15 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.quaverRest.image = toolkit15.getImage(clazz15.getResource("graphics/quaverRest.gif"));
            Toolkit toolkit16 = Toolkit.getDefaultToolkit();
            Class<?> clazz16 = class$0;
            if (clazz16 == null) {
                try {
                    clazz16 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.crotchetRest.image = toolkit16.getImage(clazz16.getResource("graphics/crotchetRest.gif"));
            Toolkit toolkit17 = Toolkit.getDefaultToolkit();
            Class<?> clazz17 = class$0;
            if (clazz17 == null) {
                try {
                    clazz17 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.minimRest.image = toolkit17.getImage(clazz17.getResource("graphics/minimRest.gif"));
            Toolkit toolkit18 = Toolkit.getDefaultToolkit();
            Class<?> clazz18 = class$0;
            if (clazz18 == null) {
                try {
                    clazz18 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.semibreveRest.image = toolkit18.getImage(clazz18.getResource("graphics/semibreveRest.gif"));
            Toolkit toolkit19 = Toolkit.getDefaultToolkit();
            Class<?> clazz19 = class$0;
            if (clazz19 == null) {
                try {
                    clazz19 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.sharp.image = toolkit19.getImage(clazz19.getResource("graphics/sharp.gif"));
            Toolkit toolkit20 = Toolkit.getDefaultToolkit();
            Class<?> clazz20 = class$0;
            if (clazz20 == null) {
                try {
                    clazz20 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.flat.image = toolkit20.getImage(clazz20.getResource("graphics/flat.gif"));
            Toolkit toolkit21 = Toolkit.getDefaultToolkit();
            Class<?> clazz21 = class$0;
            if (clazz21 == null) {
                try {
                    clazz21 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.natural.image = toolkit21.getImage(clazz21.getResource("graphics/natural.gif"));
            Toolkit toolkit22 = Toolkit.getDefaultToolkit();
            Class<?> clazz22 = class$0;
            if (clazz22 == null) {
                try {
                    clazz22 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.one = toolkit22.getImage(clazz22.getResource("graphics/one.gif"));
            Toolkit toolkit23 = Toolkit.getDefaultToolkit();
            Class<?> clazz23 = class$0;
            if (clazz23 == null) {
                try {
                    clazz23 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.two = toolkit23.getImage(clazz23.getResource("graphics/two.gif"));
            Toolkit toolkit24 = Toolkit.getDefaultToolkit();
            Class<?> clazz24 = class$0;
            if (clazz24 == null) {
                try {
                    clazz24 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.three = toolkit24.getImage(clazz24.getResource("graphics/three.gif"));
            Toolkit toolkit25 = Toolkit.getDefaultToolkit();
            Class<?> clazz25 = class$0;
            if (clazz25 == null) {
                try {
                    clazz25 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.four = toolkit25.getImage(clazz25.getResource("graphics/four.gif"));
            Toolkit toolkit26 = Toolkit.getDefaultToolkit();
            Class<?> clazz26 = class$0;
            if (clazz26 == null) {
                try {
                    clazz26 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.five = toolkit26.getImage(clazz26.getResource("graphics/five.gif"));
            Toolkit toolkit27 = Toolkit.getDefaultToolkit();
            Class<?> clazz27 = class$0;
            if (clazz27 == null) {
                try {
                    clazz27 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.six = toolkit27.getImage(clazz27.getResource("graphics/six.gif"));
            Toolkit toolkit28 = Toolkit.getDefaultToolkit();
            Class<?> clazz28 = class$0;
            if (clazz28 == null) {
                try {
                    clazz28 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.seven = toolkit28.getImage(clazz28.getResource("graphics/seven.gif"));
            Toolkit toolkit29 = Toolkit.getDefaultToolkit();
            Class<?> clazz29 = class$0;
            if (clazz29 == null) {
                try {
                    clazz29 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.eight = toolkit29.getImage(clazz29.getResource("graphics/eight.gif"));
            Toolkit toolkit30 = Toolkit.getDefaultToolkit();
            Class<?> clazz30 = class$0;
            if (clazz30 == null) {
                try {
                    clazz30 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.nine = toolkit30.getImage(clazz30.getResource("graphics/nine.gif"));
            Toolkit toolkit31 = Toolkit.getDefaultToolkit();
            Class<?> clazz31 = class$0;
            if (clazz31 == null) {
                try {
                    clazz31 = class$0 = Class.forName("jm.gui.cpn.Stave");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.delete.image = toolkit31.getImage(clazz31.getResource("graphics/delete.gif"));
        }
        catch (Exception e) {
            System.out.println("Error while loading pictures...");
            e.printStackTrace();
        }
        RGBImageFilter filter = new RGBImageFilter(){
            {
                this.canFilterIndexColorModel = true;
            }

            public int filterRGB(int x, int y, int rgb) {
                return rgb | 0xFFFF0000;
            }
        };
        this.crotchetDown.redImage = this.createImage(new FilteredImageSource(this.crotchetDown.image.getSource(), filter));
        this.crotchetUp.redImage = this.createImage(new FilteredImageSource(this.crotchetUp.image.getSource(), filter));
        this.quaverDown.redImage = this.createImage(new FilteredImageSource(this.quaverDown.image.getSource(), filter));
        this.quaverUp.redImage = this.createImage(new FilteredImageSource(this.quaverUp.image.getSource(), filter));
        this.semiquaverDown.redImage = this.createImage(new FilteredImageSource(this.semiquaverDown.image.getSource(), filter));
        this.semiquaverUp.redImage = this.createImage(new FilteredImageSource(this.semiquaverUp.image.getSource(), filter));
        this.minimDown.redImage = this.createImage(new FilteredImageSource(this.minimDown.image.getSource(), filter));
        this.minimUp.redImage = this.createImage(new FilteredImageSource(this.minimUp.image.getSource(), filter));
        this.semibreve.redImage = this.createImage(new FilteredImageSource(this.semibreve.image.getSource(), filter));
        this.dot.redImage = this.createImage(new FilteredImageSource(this.dot.image.getSource(), filter));
        this.semiquaverRest.redImage = this.createImage(new FilteredImageSource(this.semiquaverRest.image.getSource(), filter));
        this.quaverRest.redImage = this.createImage(new FilteredImageSource(this.quaverRest.image.getSource(), filter));
        this.crotchetRest.redImage = this.createImage(new FilteredImageSource(this.crotchetRest.image.getSource(), filter));
        this.minimRest.redImage = this.createImage(new FilteredImageSource(this.minimRest.image.getSource(), filter));
        this.sharp.redImage = this.createImage(new FilteredImageSource(this.sharp.image.getSource(), filter));
        this.flat.redImage = this.createImage(new FilteredImageSource(this.flat.image.getSource(), filter));
        this.natural.redImage = this.createImage(new FilteredImageSource(this.natural.image.getSource(), filter));
        this.delete.redImage = this.createImage(new FilteredImageSource(this.delete.image.getSource(), filter));
        this.bPos = 110;
        this.panelHeight = 310;
        this.setSize(this.beatWidth * 40, this.panelHeight);
    }

    public void paintComponent(Graphics graphics) {
        int pc;
        int theModValue;
        int keyAccidentalPosition;
        int ks;
        if (this.phrase == null) {
            return;
        }
        if (this.image == null) {
            this.image = this.createImage(2000, 500);
            this.g = this.image.getGraphics();
        }
        this.beatCounter = 0.0;
        this.previouslyChromatic.removeAllElements();
        this.notePositions.removeAllElements();
        int keyAccidentals = 0;
        if (this.title != null) {
            this.g.drawString(this.title, this.rightMargin, this.bPos - 50);
        }
        int keyOffset = 0;
        if (this.keySignature > 0 && this.keySignature < 8) {
            ks = 0;
            while (ks < this.keySignature) {
                keyAccidentalPosition = this.notePosOffset[this.sharps[ks] % 12] + this.bPos - 4 + (5 - this.sharps[ks] / 12) * 24 + (6 - this.sharps[ks] / 12) * 4;
                this.g.drawImage(this.sharp.image, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition, this);
                this.g.drawImage(this.sharp.image, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition + this.staveSpaceHeight * 7, this);
                keyOffset += 10;
                theModValue = this.sharps[ks] % 12;
                pc = 0;
                while (pc < 128) {
                    if (pc % 12 == theModValue) {
                        this.previouslyChromatic.addElement(new Integer(pc));
                        ++keyAccidentals;
                    }
                    ++pc;
                }
                this.keySigWidth = keyOffset;
                ++ks;
            }
        } else if (this.keySignature < 0 && this.keySignature > -8) {
            ks = 0;
            while (ks < Math.abs(this.keySignature)) {
                keyAccidentalPosition = this.notePosOffset[this.flats[ks] % 12] + this.bPos - 4 + (5 - this.flats[ks] / 12) * 24 + (6 - this.flats[ks] / 12) * 4;
                this.g.drawImage(this.flat.image, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition, this);
                this.g.drawImage(this.flat.image, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition + this.staveSpaceHeight * 7, this);
                keyOffset += 10;
                theModValue = this.flats[ks] % 12;
                pc = 0;
                while (pc < 128) {
                    if (pc % 12 == theModValue) {
                        this.previouslyChromatic.addElement(new Integer(pc));
                        ++keyAccidentals;
                    }
                    ++pc;
                }
                ++ks;
            }
        }
        this.keySigWidth = keyOffset + 3;
        if (this.metre != 0.0) {
            Image[] numbers = new Image[]{this.one, this.two, this.three, this.four, this.five, this.six, this.seven, this.eight, this.nine};
            this.g.drawImage(numbers[(int)this.metre - 1], this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 13, this);
            this.g.drawImage(numbers[(int)this.metre - 1], this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 13 + this.staveSpaceHeight * 6, this);
            this.g.drawImage(this.four, this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 29, this);
            this.g.drawImage(this.four, this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 29 + this.staveSpaceHeight * 6, this);
            this.timeSigWidth = 30;
        } else {
            this.timeSigWidth = 5;
        }
        this.totalBeatWidth = this.rightMargin + this.clefWidth + this.keySigWidth + this.timeSigWidth;
        this.firstChords = ChordAnalysis.getFirstPassChords(this.phrase, 1.0, this.tonic, this.scale);
        this.secondChords = ChordAnalysis.getSecondPassChords(this.phrase, 1.0, this.tonic, this.scale);
        this.lastChordDisplayed = -1;
        int i = 0;
        while (i < this.phrase.size()) {
            int notePitchNum = this.phrase.getNote(i).getPitch();
            int pitchTempPos = notePitchNum == Integer.MIN_VALUE || this.phrase.getNote(i).getRhythmValue() == 0.0 ? this.notePosOffset[11] + this.bPos - 4 + 0 + 4 : this.notePosOffset[notePitchNum % 12] + this.bPos - 4 + (5 - notePitchNum / 12) * 24 + (6 - notePitchNum / 12) * 4;
            this.isNormalColor = notePitchNum == Integer.MIN_VALUE || PhraseAnalysis.isScale(this.phrase.getNote(i), this.tonic, this.scale);
            this.firstAccidentalDisplayed = false;
            this.semitoneShiftUp = false;
            this.isTied = false;
            this.isFirstNoteInTie = true;
            this.extraImagesUsed = false;
            this.savedBeatWidth = this.totalBeatWidth;
            this.savedBeatWidth2 = 0;
            double rhythmValue = this.phrase.getNote(i).getRhythmValue();
            double rvToEndOfBar = this.metre - this.beatCounter % this.metre;
            while (rvToEndOfBar < rhythmValue) {
                this.isTied = true;
                this.drawNote(notePitchNum, rvToEndOfBar, pitchTempPos, keyAccidentals);
                rhythmValue -= rvToEndOfBar;
                rvToEndOfBar = this.metre - this.beatCounter % this.metre;
            }
            this.drawNote(notePitchNum, rhythmValue, pitchTempPos, keyAccidentals);
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        i = 6;
        while (i < 11) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        this.g.setColor(Color.darkGray);
        i = -7;
        while (i < -2) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        i = 13;
        while (i < 18) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        this.g.setColor(Color.lightGray);
        i = 0;
        while (i < 5) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth + 50, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        i = 6;
        while (i < 11) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth + 50, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        this.g.setColor(Color.black);
        this.g.drawImage(this.trebleClef, this.rightMargin + 7, this.bPos - 4, this);
        this.g.drawImage(this.bassClef, this.rightMargin + 7, this.bPos + this.staveSpaceHeight * 6, this);
        graphics.drawImage(this.image, 0, 0, null);
        this.g.setColor(this.getBackground());
        this.g.fillRect(0, 0, 2000, 500);
        this.g.setColor(this.getForeground());
    }

    private void drawNote(int notePitchNum, double rhythmValue, int pitchTempPos, int keyAccidentals) {
        this.requiresMoreThanOneImage = false;
        this.excessRhythmValue = 0.0;
        if (this.beatCounter % 1.0 == 0.0) {
            int total;
            int currentBeat = (int)(this.beatCounter / 1.0);
            int remaining = total = currentBeat - this.lastChordDisplayed;
            while (this.lastChordDisplayed < currentBeat) {
                ++this.lastChordDisplayed;
                this.g.drawString(this.chordStrings[this.firstChords[this.lastChordDisplayed]], (int)((double)this.totalBeatWidth - (double)(this.totalBeatWidth - this.lastPosition) * ((double)(--remaining) / (double)total)), 20);
                int index = this.secondChords[this.lastChordDisplayed];
                String string = this.chordStrings[index];
                this.g.drawString(string, (int)((double)this.totalBeatWidth - (double)(this.totalBeatWidth - this.lastPosition) * ((double)remaining / (double)total)), 40);
            }
            this.lastPosition = this.totalBeatWidth;
        }
        this.chooseImage(notePitchNum, rhythmValue, 71, 60, 50);
        this.drawNote2(notePitchNum, rhythmValue - this.excessRhythmValue, pitchTempPos, keyAccidentals);
        if (this.requiresMoreThanOneImage) {
            this.drawNote(notePitchNum, this.excessRhythmValue, pitchTempPos, keyAccidentals);
            this.extraImagesUsed = true;
        }
    }

    private void drawNote2(int notePitchNum, double rhythmValue, int pitchTempPos, int keyAccidentals) {
        if ((notePitchNum % 12 == 1 || notePitchNum % 12 == 3 || notePitchNum % 12 == 6 || notePitchNum % 12 == 8 || notePitchNum % 12 == 10) && notePitchNum != Integer.MIN_VALUE && rhythmValue != 0.0) {
            if (this.keySignature > -1) {
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.sharp, this.totalBeatWidth - 9, pitchTempPos);
                }
                this.previouslyChromatic.addElement(new Integer(notePitchNum - 1));
            } else {
                pitchTempPos -= 4;
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.flat, this.totalBeatWidth - 9, pitchTempPos);
                }
                this.previouslyChromatic.addElement(new Integer(notePitchNum + 1));
                ++notePitchNum;
                this.semitoneShiftUp = true;
            }
        } else {
            int size = this.previouslyChromatic.size();
            int j = 0;
            while (j < size) {
                Integer temp = (Integer)this.previouslyChromatic.elementAt(j);
                if (temp == notePitchNum && notePitchNum != Integer.MIN_VALUE && rhythmValue != 0.0) {
                    if (!this.firstAccidentalDisplayed) {
                        this.displayImage(this.g, this.natural, this.totalBeatWidth - 7, pitchTempPos);
                    }
                    if (j > keyAccidentals - 1) {
                        this.previouslyChromatic.removeElementAt(j);
                    }
                    j = size;
                }
                ++j;
            }
        }
        this.firstAccidentalDisplayed = true;
        this.displayImage(this.g, this.currImage, this.totalBeatWidth, pitchTempPos);
        this.notePositions.addElement(new Integer(this.totalBeatWidth));
        this.notePositions.addElement(new Integer(pitchTempPos));
        if (this.dottedNote) {
            boolean dotFlag = true;
            int l = 0;
            while (l < this.lineNotes.length) {
                if (this.lineNotes[l] + 12 == notePitchNum || this.lineNotes[l] + 36 == notePitchNum || this.lineNotes[l] + 60 == notePitchNum || this.lineNotes[l] + 84 == notePitchNum || this.lineNotes[l] + 108 == notePitchNum || notePitchNum == Integer.MIN_VALUE) {
                    this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, pitchTempPos - 4);
                    dotFlag = false;
                    l = this.lineNotes.length;
                }
                ++l;
            }
            if (dotFlag) {
                this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, pitchTempPos);
            }
        }
        if (notePitchNum == 60 || notePitchNum == 61 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 52, this.totalBeatWidth + 12, this.bPos + 52);
        }
        if (notePitchNum <= 40 && notePitchNum > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 100, this.totalBeatWidth + 12, this.bPos + 100);
        }
        if (notePitchNum <= 37 && notePitchNum > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 108, this.totalBeatWidth + 12, this.bPos + 108);
        }
        if (notePitchNum <= 16 && notePitchNum > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 156, this.totalBeatWidth + 12, this.bPos + 156);
        }
        if (notePitchNum <= 13 && notePitchNum > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 164, this.totalBeatWidth + 12, this.bPos + 164);
        }
        if (notePitchNum <= 10 && notePitchNum > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 172, this.totalBeatWidth + 12, this.bPos + 172);
        }
        if (notePitchNum <= 6 && notePitchNum > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 180, this.totalBeatWidth + 12, this.bPos + 180);
        }
        if (notePitchNum <= 3 && notePitchNum > -1 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 188, this.totalBeatWidth + 12, this.bPos + 188);
        }
        if (notePitchNum >= 81 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 4, this.totalBeatWidth + 12, this.bPos + 4);
        }
        if (notePitchNum >= 84 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 4, this.totalBeatWidth + 12, this.bPos - 4);
        }
        if (notePitchNum >= 105 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 52, this.totalBeatWidth + 12, this.bPos - 52);
        }
        if (notePitchNum >= 108 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 60, this.totalBeatWidth + 12, this.bPos - 60);
        }
        if (notePitchNum >= 112 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 68, this.totalBeatWidth + 12, this.bPos - 68);
        }
        if (notePitchNum >= 115 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 76, this.totalBeatWidth + 12, this.bPos - 76);
        }
        if (notePitchNum >= 119 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 84, this.totalBeatWidth + 12, this.bPos - 84);
        }
        if (notePitchNum >= 122 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 92, this.totalBeatWidth + 12, this.bPos - 92);
        }
        if (notePitchNum >= 125 && notePitchNum < 128 && rhythmValue != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 100, this.totalBeatWidth + 12, this.bPos - 100);
        }
        this.savedBeatWidth2 = this.totalBeatWidth;
        if ((this.isTied || this.extraImagesUsed) && this.isNote && !this.isFirstNoteInTie) {
            Image tieImage = this.tie.image;
            if (!this.isNormalColor) {
                tieImage = this.tie.redImage;
            }
            int yPosition = pitchTempPos + 19 - (this.semitoneShiftUp ? 4 : 0);
            if (this.isUp) {
                this.g.drawImage(tieImage, this.savedBeatWidth - 3 + 9, yPosition + 17 + tieImage.getHeight(this), this.savedBeatWidth2 + 19 - 9, yPosition + 17, 0, 0, tieImage.getWidth(this), tieImage.getHeight(this), this);
            } else {
                this.g.drawImage(tieImage, this.savedBeatWidth - 3 + 9, yPosition - 20, this.savedBeatWidth2 + 19 - 9, yPosition - 20 + tieImage.getHeight(this), 0, 0, tieImage.getWidth(this), tieImage.getHeight(this), this);
            }
        }
        this.isFirstNoteInTie = true;
        if (true) {
            this.isFirstNoteInTie = false;
        }
        this.savedBeatWidth = this.totalBeatWidth;
        this.totalBeatWidth += this.currBeatWidth;
        this.dottedNote = false;
        this.beatCounter += (double)((int)(rhythmValue / 0.25)) * 0.25;
        if (this.metre != 0.0 && this.beatCounter % this.metre == 0.0) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + 12 - this.staveSpaceHeight * 7, this.totalBeatWidth, this.bPos + 44 + this.staveSpaceHeight * 13);
            if (this.barNumbers) {
                this.g.drawString("" + (int)(this.beatCounter / this.metre + 1.0), this.totalBeatWidth - 4, this.bPos - 50);
            }
            this.totalBeatWidth += 12;
        }
    }

    public void displayImage(Graphics g, RedFilter image, int xCoord, int yCoord) {
        if (this.isNormalColor) {
            g.drawImage(image.image, xCoord, yCoord, this);
        } else {
            g.drawImage(image.redImage, xCoord, yCoord, this);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(2000, 500);
    }

    public void setPhrase(Phrase phr) {
        this.phrase = phr;
        this.previouslyChromatic.removeAllElements();
        this.setTitle(phr.getTitle());
        this.repaint();
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void removeTitle() {
        this.title = null;
    }

    public void setMetre(double timeSig) {
        this.metre = timeSig;
    }

    public double getMetre() {
        return this.metre;
    }

    public void setScale(int[] scale) {
        this.scale = scale;
        this.setTonic(this.tonic);
    }

    public int getTonic() {
        return this.tonic;
    }

    public void setKey(int degree, int[] scale) {
        this.scale = scale;
        this.setTonic(degree);
    }

    public void setTonic(int degree) {
        if (degree < 0 || degree > 11) {
            return;
        }
        if (this.scale == Scales.MAJOR_SCALE) {
            this.tonic = degree;
        } else if (this.scale == Scales.NATURAL_MINOR_SCALE) {
            this.tonic = degree;
            degree = (degree + 3) % 12;
        } else {
            return;
        }
        int i = 0;
        while (i < keys.length) {
            if (keys[i] == degree) {
                this.keySignature = i - 7;
            }
            ++i;
        }
        this.repaint();
        if (this.keyChangeListener == null) {
            return;
        }
        this.keyChangeListener.keyChanged();
    }

    public void setKeyChangeListener(KeyChangeListener listener) {
        this.keyChangeListener = listener;
    }

    public void setKeySignature(int key) {
        int n = key > 7 ? 7 : (this.keySignature = key < -7 ? -7 : key);
        if (this.keyChangeListener == null) {
            return;
        }
        this.keyChangeListener.keyChanged();
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setBarNumbers(boolean show) {
        this.barNumbers = show;
    }

    public void setEditable(boolean state) {
        this.editable = state;
    }

    public int getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(int min) {
        this.minPitch = min;
    }

    public int getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(int max) {
        this.maxPitch = max;
    }

    public int getTotalBeatWidth() {
        return this.totalBeatWidth;
    }

    public void setTotalBeatWidth(int width) {
        this.totalBeatWidth = width;
    }

    public boolean getBarNumbers() {
        return this.barNumbers;
    }

    public boolean getQtOn() {
        return this.qtOn;
    }

    public void setQtOn(boolean state) {
        this.qtOn = state;
    }

    public void updateChange() {
    }

    public void deleteLastNote() {
        if (this.phrase.size() > 0) {
            this.phrase.removeNote(this.phrase.size() - 1);
            this.repaint();
            this.updateChange();
        }
    }

    protected void chooseImage(int pitch, double rhythmValue, int upPitch1, int downPitch, int upPitch2) {
        if (pitch == Integer.MIN_VALUE) {
            this.isNote = false;
            if (rhythmValue <= 0.0) {
                this.currImage = this.delete;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            }
            if (rhythmValue > 0.0 && rhythmValue <= 0.25) {
                this.currImage = this.semiquaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            }
            if (rhythmValue > 0.25 && rhythmValue <= 0.5) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
            }
            if (rhythmValue > 0.5 && rhythmValue <= 0.75) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                this.dottedNote = true;
            }
            if (rhythmValue > 0.75 && rhythmValue <= 1.0) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
            }
            if (rhythmValue > 1.0 && rhythmValue <= 1.25) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 1.0;
            }
            if (rhythmValue > 1.25 && rhythmValue <= 1.5) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
            }
            if (rhythmValue > 1.5 && rhythmValue <= 1.75) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 1.5;
            }
            if (rhythmValue > 1.75 && rhythmValue <= 2.0) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
            }
            if (rhythmValue > 2.0 && rhythmValue <= 2.75) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 2.0;
            }
            if (rhythmValue > 2.75 && rhythmValue <= 3.0) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
            }
            if (rhythmValue > 3.0 && rhythmValue <= 3.75) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 3.0;
            }
            if (rhythmValue > 3.75 && rhythmValue <= 4.0) {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            }
        } else {
            this.isNote = true;
            if (pitch < upPitch1 && pitch >= downPitch || pitch < upPitch2) {
                if (rhythmValue <= 0.0) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = true;
                }
                if (rhythmValue > 0.0 && rhythmValue <= 0.25) {
                    this.currImage = this.semiquaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = true;
                }
                if (rhythmValue > 0.25 && rhythmValue <= 0.5) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.isUp = true;
                }
                if (rhythmValue > 0.5 && rhythmValue <= 0.75) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.dottedNote = true;
                    this.isUp = true;
                }
                if (rhythmValue > 0.75 && rhythmValue <= 1.0) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                    this.isUp = true;
                }
                if (rhythmValue > 1.0 && rhythmValue <= 1.25) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.0;
                    this.isUp = true;
                }
                if (rhythmValue > 1.25 && rhythmValue <= 1.5) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.isUp = true;
                }
                if (rhythmValue > 1.5 && rhythmValue <= 1.75) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.5;
                    this.isUp = true;
                }
                if (rhythmValue > 1.75 && rhythmValue <= 2.0) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.isUp = true;
                }
                if (rhythmValue > 2.0 && rhythmValue <= 2.75) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 2.0;
                    this.isUp = true;
                }
                if (rhythmValue > 2.75 && rhythmValue <= 3.0) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.isUp = true;
                }
                if (rhythmValue > 3.0 && rhythmValue <= 3.75) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 3.0;
                    this.isUp = true;
                }
                if (rhythmValue > 3.75 && rhythmValue <= 4.0) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.isUp = true;
                }
            } else {
                if (rhythmValue <= 0.0) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = false;
                }
                if (rhythmValue > 0.0 && rhythmValue <= 0.25) {
                    this.currImage = this.semiquaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = false;
                }
                if (rhythmValue > 0.25 && rhythmValue <= 0.5) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.isUp = false;
                }
                if (rhythmValue > 0.5 && rhythmValue <= 0.75) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.dottedNote = true;
                    this.isUp = false;
                }
                if (rhythmValue > 0.75 && rhythmValue <= 1.0) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                    this.isUp = false;
                }
                if (rhythmValue > 1.0 && rhythmValue <= 1.25) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.0;
                    this.isUp = false;
                }
                if (rhythmValue > 1.25 && rhythmValue <= 1.5) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.isUp = false;
                }
                if (rhythmValue > 1.5 && rhythmValue <= 1.75) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.5;
                    this.isUp = false;
                }
                if (rhythmValue > 1.75 && rhythmValue <= 2.0) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.isUp = false;
                }
                if (rhythmValue > 2.0 && rhythmValue <= 2.75) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 2.0;
                    this.isUp = false;
                }
                if (rhythmValue > 2.75 && rhythmValue <= 3.0) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.isUp = false;
                }
                if (rhythmValue > 3.0 && rhythmValue <= 3.75) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 3.0;
                    this.isUp = false;
                }
                if (rhythmValue > 3.75 && rhythmValue <= 4.0) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.isUp = false;
                }
            }
        }
    }

    class RedFilter {
        public Image image;
        public Image redImage;

        RedFilter() {
        }

        RedFilter(Image image) {
            this.image = image;
            this.redImage = JGrandStave.this.createImage(new FilteredImageSource(image.getSource(), JGrandStave.this.filter));
        }
    }
}

