/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import jm.JMC;
import jm.gui.cpn.Stave;
import jm.music.data.Phrase;

public class BassStave
extends Stave
implements JMC {
    public BassStave() {
        this.staveDelta = this.staveSpaceHeight * 11 / 2;
    }

    public BassStave(Phrase phrase) {
        super(phrase);
        this.staveDelta = this.staveSpaceHeight * 11 / 2;
    }

    public void paint(Graphics graphics) {
        int pc;
        int theModValue;
        int keyAccidentalPosition;
        int ks;
        if (this.image == null) {
            this.image = this.createImage(this.getSize().width, this.getSize().height);
            this.g = this.image.getGraphics();
        }
        this.g.setFont(this.font);
        double beatCounter = 0.0;
        this.previouslyChromatic.removeAllElements();
        this.notePositions.removeAllElements();
        int keyAccidentals = 0;
        if (this.getDisplayTitle()) {
            this.g.drawString(this.title, this.rightMargin, this.bPos - 10);
        }
        int keyOffset = 0;
        if (this.keySignature > 0 && this.keySignature < 8) {
            ks = 0;
            while (ks < this.keySignature) {
                keyAccidentalPosition = this.notePosOffset[this.sharps[ks] % 12] + this.bPos - 4 + (5 - this.sharps[ks] / 12) * 24 + (6 - this.sharps[ks] / 12) * 4;
                this.g.drawImage(this.sharp, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition + this.staveSpaceHeight, this);
                keyOffset += 10;
                theModValue = this.sharps[ks] % 12;
                pc = 0;
                while (pc < 128) {
                    if (pc % 12 == theModValue) {
                        this.previouslyChromatic.addElement(new Integer(pc));
                        ++keyAccidentals;
                    }
                    ++pc;
                }
                this.keySigWidth = keyOffset;
                ++ks;
            }
        } else if (this.keySignature < 0 && this.keySignature > -8) {
            ks = 0;
            while (ks < Math.abs(this.keySignature)) {
                keyAccidentalPosition = this.notePosOffset[this.flats[ks] % 12] + this.bPos - 4 + (5 - this.flats[ks] / 12) * 24 + (6 - this.flats[ks] / 12) * 4;
                this.g.drawImage(this.flat, this.rightMargin + this.clefWidth + keyOffset, keyAccidentalPosition + this.staveSpaceHeight, this);
                keyOffset += 10;
                theModValue = this.flats[ks] % 12;
                pc = 0;
                while (pc < 128) {
                    if (pc % 12 == theModValue) {
                        this.previouslyChromatic.addElement(new Integer(pc));
                        ++keyAccidentals;
                    }
                    ++pc;
                }
                ++ks;
            }
        }
        this.keySigWidth = keyOffset + 3;
        if (this.metre != 0.0) {
            Image[] numbers = new Image[]{this.one, this.two, this.three, this.four, this.five, this.six, this.seven, this.eight, this.nine};
            this.g.drawImage(numbers[(int)this.metre - 1], this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 13, this);
            this.g.drawImage(this.four, this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 29, this);
            this.timeSigWidth = 30;
        } else {
            this.timeSigWidth = 5;
        }
        this.totalBeatWidth = this.rightMargin + this.clefWidth + this.keySigWidth + this.timeSigWidth;
        int i = 0;
        while (i < this.phrase.size()) {
            int notePitchNum = this.phrase.getNote(i).getPitch();
            this.chooseImage(notePitchNum, this.phrase.getNote(i).getRhythmValue(), 50, 0, 50);
            int pitchTempPos = notePitchNum == Integer.MIN_VALUE || this.phrase.getNote(i).getRhythmValue() == 0.0 ? this.notePosOffset[11] + this.bPos - 4 + 0 + 4 : this.notePosOffset[notePitchNum % 12] + this.bPos - 4 + (5 - notePitchNum / 12) * 24 + ((6 - notePitchNum / 12) * 4 - this.staveSpaceHeight * 6);
            if ((notePitchNum % 12 == 1 || notePitchNum % 12 == 3 || notePitchNum % 12 == 6 || notePitchNum % 12 == 8 || notePitchNum % 12 == 10) && notePitchNum != Integer.MIN_VALUE && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                if (this.keySignature > -1) {
                    this.g.drawImage(this.sharp, this.totalBeatWidth - 9, pitchTempPos, this);
                    this.previouslyChromatic.addElement(new Integer(notePitchNum - 1));
                } else {
                    this.g.drawImage(this.flat, this.totalBeatWidth - 9, pitchTempPos -= 4, this);
                    this.previouslyChromatic.addElement(new Integer(notePitchNum + 1));
                    ++notePitchNum;
                }
            } else {
                int size = this.previouslyChromatic.size();
                int j = 0;
                while (j < size) {
                    Integer temp = (Integer)this.previouslyChromatic.elementAt(j);
                    if (temp == notePitchNum && notePitchNum != Integer.MIN_VALUE && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                        this.g.drawImage(this.natural, this.totalBeatWidth - 7, pitchTempPos, this);
                        if (j > keyAccidentals - 1) {
                            this.previouslyChromatic.removeElementAt(j);
                        }
                        j = size;
                    }
                    ++j;
                }
            }
            this.g.drawImage(this.currImage, this.totalBeatWidth, pitchTempPos, this);
            this.notePositions.addElement(new Integer(this.totalBeatWidth));
            this.notePositions.addElement(new Integer(pitchTempPos + this.staveDelta));
            if (this.dottedNote) {
                boolean dotFlag = true;
                int l = 0;
                while (l < this.lineNotes.length) {
                    if (this.lineNotes[l] + 12 == notePitchNum || this.lineNotes[l] + 36 == notePitchNum || this.lineNotes[l] + 60 == notePitchNum || this.lineNotes[l] + 84 == notePitchNum || this.lineNotes[l] + 108 == notePitchNum || notePitchNum == Integer.MIN_VALUE) {
                        this.g.drawImage(this.dot, this.totalBeatWidth + 1, pitchTempPos - 4, this);
                        dotFlag = false;
                        l = this.lineNotes.length;
                    }
                    ++l;
                }
                if (dotFlag) {
                    this.g.drawImage(this.dot, this.totalBeatWidth + 1, pitchTempPos, this);
                }
            }
            if (notePitchNum <= 40 && notePitchNum > -1 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 52, this.totalBeatWidth + 12, this.bPos + 52);
            }
            if (notePitchNum <= 37 && notePitchNum > -1 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 60, this.totalBeatWidth + 12, this.bPos + 60);
            }
            if (notePitchNum <= 34 && notePitchNum > -1 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 68, this.totalBeatWidth + 12, this.bPos + 68);
            }
            if (notePitchNum <= 30 && notePitchNum > -1 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 76, this.totalBeatWidth + 12, this.bPos + 76);
            }
            if (notePitchNum <= 26 && notePitchNum > -1 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 84, this.totalBeatWidth + 12, this.bPos + 84);
            }
            if (notePitchNum >= 60 && notePitchNum < 128 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 4, this.totalBeatWidth + 12, this.bPos + 4);
            }
            if (notePitchNum >= 64 && notePitchNum < 128 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 4, this.totalBeatWidth + 12, this.bPos - 4);
            }
            if (notePitchNum >= 67 && notePitchNum < 128 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 12, this.totalBeatWidth + 12, this.bPos - 12);
            }
            if (notePitchNum >= 71 && notePitchNum < 128 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 20, this.totalBeatWidth + 12, this.bPos - 20);
            }
            if (notePitchNum >= 74 && notePitchNum < 128 && this.phrase.getNote(i).getRhythmValue() != 0.0) {
                this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 28, this.totalBeatWidth + 12, this.bPos - 28);
            }
            this.totalBeatWidth += this.currBeatWidth;
            this.dottedNote = false;
            if (this.metre != 0.0 && (beatCounter += (double)((int)(this.phrase.getNote(i).getRhythmValue() / 0.25)) * 0.25) % this.metre == 0.0) {
                this.g.drawLine(this.totalBeatWidth, this.bPos + 12, this.totalBeatWidth, this.bPos + 44);
                if (this.barNumbers) {
                    this.g.drawString("" + (int)(beatCounter / this.metre + 1.0 + this.phrase.getStartTime()), this.totalBeatWidth - 4, this.bPos);
                }
                this.totalBeatWidth += 12;
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        this.g.setColor(Color.lightGray);
        i = 0;
        while (i < 5) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight, this.totalBeatWidth + 50, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + i * this.staveSpaceHeight);
            ++i;
        }
        this.g.setColor(Color.black);
        this.g.drawImage(this.bassClef, this.rightMargin + 7, this.bPos, this);
        graphics.drawImage(this.image, 0, 0, null);
        this.g.setColor(this.getBackground());
        this.g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.g.setColor(this.getForeground());
    }
}

