/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Volume
extends AudioObject {
    float mainVolume = 1.0f;
    float volume = 1.0f;
    double linearVolumeValue = 1.0;

    public Volume(AudioObject ao) {
        this(ao, 1.0f);
    }

    public Volume(AudioObject ao, double volume) {
        this(ao, (float)volume);
    }

    public Volume(AudioObject ao, float volume) {
        super(ao, "[Volume]");
        this.mainVolume = volume;
    }

    public void build() {
        this.linearVolumeValue = (double)this.currentNote.getDynamic() / 127.0;
        this.volume = (float)(1.0 - Math.log(128.0 - (double)this.currentNote.getDynamic()) * 0.2) * this.mainVolume;
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].nextWork(buffer);
        if (this.inputs == 2) {
            float[] tmp = new float[buffer.length];
            if (returned != this.previous[1].nextWork(tmp)) {
                throw new AOException(this.name, 0);
            }
            int i = 0;
            while (i < returned) {
                buffer[i] = buffer[i] * tmp[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < returned) {
                buffer[i] = buffer[i] * this.volume;
                ++i;
            }
        }
        return returned;
    }

    public void setVolume(double volValue) {
        this.linearVolumeValue = volValue;
        this.volume = (float)Math.min(1.0, Math.abs(Math.log(1.0 - volValue) * 0.2));
    }

    public double getVolume() {
        return this.linearVolumeValue;
    }
}

