/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.SpringPipe;

public class Spring
extends AudioObject {
    private SpringPipe springNetwork;
    private int numberOfNodes = 8;
    private double springConstant;
    private double massFriction;
    private double jitter;

    public Spring(Instrument inst, int nodes) {
        this(inst, nodes, 44100.0, 1.0);
    }

    public Spring(Instrument inst, int nodes, double springConstant, double massFriction) {
        this(inst, nodes, springConstant, massFriction, 0.0, 44100, 1);
    }

    public Spring(Instrument inst, int nodes, double springConstant, double massFriction, double jitter, int sampleRate, int channels) {
        super(inst, sampleRate, "[WaveTable]");
        this.numberOfNodes = nodes;
        this.springConstant = springConstant;
        this.jitter = jitter;
        this.massFriction = massFriction;
        this.channels = channels;
    }

    public void build() {
        this.springNetwork = new SpringPipe(this.numberOfNodes, this.springConstant, this.massFriction, this.jitter);
    }

    public int work(float[] buffer) throws AOException {
        int ret = 0;
        while (ret < buffer.length) {
            int j = 0;
            while (j < this.channels) {
                buffer[ret++] = (float)(this.springNetwork.getNextNodePosition(0) / (double)(40 / this.numberOfNodes) - 3.0);
                ++j;
            }
        }
        return ret;
    }
}

