/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Smooth
extends AudioObject {
    private float[] prevSampleValues;

    public Smooth(AudioObject ao) {
        super(ao, "[Smooth]");
    }

    public void build() {
        this.prevSampleValues = new float[this.channels];
        int i = 0;
        while (i < this.prevSampleValues.length) {
            this.prevSampleValues[i] = 0.0f;
            ++i;
        }
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].nextWork(buffer);
        int i = 0;
        while (i < returned) {
            int j = 0;
            while (j < this.channels) {
                buffer[i + j] = buffer[i + j] * 0.5f + this.prevSampleValues[j] * 0.5f;
                this.prevSampleValues[j] = buffer[i + j];
                ++j;
            }
            i += this.channels;
        }
        return returned;
    }
}

