/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.constants.Frequencies;

public final class Pluck
extends AudioObject {
    private int index = 0;
    float[] kernel = null;
    private boolean primary = true;
    private float prevSample = 0.0f;
    private float feedback = 0.49f;
    private float decay = 0.5f;
    private int delay = 1;
    private float[] delayLine;
    private int delayIndex;

    public Pluck(Instrument inst, int sampleRate, int channels) {
        this(inst, sampleRate, channels, 0.49);
    }

    public Pluck(Instrument inst, int sampleRate, int channels, double feedback) {
        super(inst, sampleRate, "[Pluck]");
        this.channels = channels;
        this.feedback = (float)feedback;
    }

    public Pluck(AudioObject ao) {
        this(ao, 0.5);
    }

    public Pluck(AudioObject ao, double feedback) {
        super(ao, "[Pluck]");
        this.primary = false;
        this.feedback = (float)feedback;
    }

    public void setFeedback(double feedback) {
        this.feedback = (float)feedback;
    }

    public void build() {
        double freq = Frequencies.FRQ[this.currentNote.getPitch()];
        int length = (int)((double)this.sampleRate / freq);
        this.kernel = new float[length];
        int i = 0;
        while (i < length) {
            this.kernel[i] = this.primary ? (float)(Math.random() * 2.0 - 1.0) : 0.0f;
            ++i;
        }
        int sampleDelay = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
        this.delayLine = new float[sampleDelay * this.channels];
        this.delayIndex = 0;
    }

    public int work(float[] buffer) throws AOException {
        int i = 0;
        float temp = 0.0f;
        if (this.primary) {
            if (this.index >= this.kernel.length) {
                this.index = 0;
            }
            while (i < buffer.length) {
                temp = this.kernel[this.index];
                int j = 0;
                while (j < this.channels) {
                    buffer[i] = this.kernel[this.index];
                    try {
                        int n = i;
                        buffer[n] = buffer[n] + this.delayLine[this.delayIndex] * this.decay;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("jMusic Pluck audio object error: i = " + i + " delayIndex = " + this.delayIndex);
                    }
                    float a = buffer[i] * -this.decay;
                    float b = this.delayLine[this.delayIndex];
                    this.delayLine[this.delayIndex] = buffer[i];
                    buffer[i] = a + b;
                    if (this.delayIndex >= this.delayLine.length) {
                        this.delayIndex = 0;
                    }
                    ++i;
                    ++j;
                }
                this.kernel[this.index] = (this.kernel[this.index] + this.prevSample) * this.feedback;
                this.prevSample = temp;
                ++this.index;
                if (this.index < this.kernel.length) continue;
                this.index = 0;
            }
        } else {
            if (this.index >= this.kernel.length) {
                this.index = 0;
            }
            while (i < buffer.length) {
                temp = buffer[i];
                this.kernel[this.index] = (buffer[i] + this.prevSample) * this.feedback;
                int j = 0;
                while (j < this.channels) {
                    buffer[i++] = this.kernel[this.index];
                    ++j;
                }
                this.prevSample = temp;
                ++this.index;
                if (this.index < this.kernel.length) continue;
                this.index = 0;
            }
        }
        return i;
    }
}

