/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class Oscillator
extends AudioObject {
    public static final int SINE_WAVE = 0;
    public static final int COSINE_WAVE = 1;
    public static final int TRIANGLE_WAVE = 2;
    public static final int SQUARE_WAVE = 3;
    public static final int SAWTOOTH_WAVE = 4;
    public static final int SAWDOWN_WAVE = 5;
    public static final int SABERSAW_WAVE = 6;
    public static final int PULSE_WAVE = 7;
    public static final int AMPLITUDE = 0;
    public static final int FREQUENCY = 1;
    private float si;
    private float phase;
    private int choice;
    private float amp = 1.0f;
    private float frq = -1.0f;
    private float frqRatio = 1.0f;
    private int waveType = 0;
    private double pulseWidth = 0.15;

    public Oscillator(AudioObject[] ao) throws AOException {
        super(ao, "[Oscillator]");
        if (ao.length > 2) {
            throw new AOException(this.name, 1);
        }
    }

    public Oscillator(AudioObject ao, int waveType, int choice) {
        super(ao, "[Oscillator]");
        this.waveType = waveType;
        this.choice = choice;
    }

    public Oscillator(AudioObject ao, int waveType, int choice, double val) {
        super(ao, "[Oscillator]");
        this.waveType = waveType;
        this.choice = choice;
        if (choice == 1) {
            this.frq = (float)val;
        } else {
            this.amp = (float)val;
        }
    }

    public Oscillator(Instrument inst) {
        this(inst, 0);
    }

    public Oscillator(Instrument inst, int waveType) {
        this(inst, waveType, 44100);
    }

    public Oscillator(Instrument inst, int waveType, int sampleRate) {
        this(inst, waveType, sampleRate, 1);
    }

    public Oscillator(Instrument inst, int waveType, int sampleRate, int channels) {
        super(inst, sampleRate, "[Oscillator]");
        this.waveType = waveType;
        this.channels = channels;
    }

    public Oscillator(Instrument inst, int waveType, int sampleRate, int channels, int fixedModChoice, double freqVal) {
        super(inst, sampleRate, "[Oscillator]");
        this.waveType = waveType;
        this.channels = channels;
        this.choice = fixedModChoice;
        if (this.choice == 1) {
            this.frq = (float)freqVal;
        } else {
            this.amp = (float)freqVal;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int work(float[] buffer) throws AOException {
        block13: {
            block14: {
                block12: {
                    buffneed = buffer.length / this.channels;
                    ret = 0;
                    if (this.inputs != 2) break block12;
                    ampbuf = new float[buffneed];
                    returned = this.previous[0].nextWork(ampbuf);
                    if (returned != this.previous[1].work(freqbuf = new float[returned])) {
                        throw new AOException(this.name, 0);
                    }
                    i = 0;
                    while (ret < buffer.length) {
                        this.setSI(freqbuf[i] * this.frqRatio);
                        sample = this.getWaveSample() * this.amp * ampbuf[i];
                        j = 0;
                        while (j < this.channels) {
                            buffer[ret++] = sample;
                            ++j;
                        }
                        ++i;
                    }
                    break block13;
                }
                if (this.inputs != 1 || this.choice != 0) break block14;
                ampbuf = new float[buffneed];
                returned = this.previous[0].nextWork(ampbuf);
                i = 0;
                while (ret < buffer.length) {
                    sample = this.getWaveSample() * this.amp * ampbuf[i];
                    j = 0;
                    while (j < this.channels) {
                        buffer[ret++] = sample;
                        ++j;
                    }
                    ++i;
                }
                break block13;
            }
            if (this.inputs != 1 || this.choice != 1) ** GOTO lbl63
            frqbuf = new float[buffneed];
            returned = this.previous[0].work(frqbuf);
            i = 0;
            while (i < buffneed) {
                this.setSI(frqbuf[i] * this.frqRatio);
                sample = this.getWaveSample() * this.amp;
                j = 0;
                while (j < this.channels) {
                    buffer[ret++] = sample;
                    ++j;
                }
                ++i;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                if (this.choice == 1) {
                    this.setSI(this.frq);
                }
                sample = this.getWaveSample() * this.amp;
                j = 0;
                while (j < this.channels) {
                    try {
                        buffer[ret++] = sample;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        --ret;
                    }
                    ++j;
                }
lbl63:
                // 2 sources

                ** while (ret < buffer.length)
            }
        }
        return ret;
    }

    public void build() {
        if (this.frq < 0.0f) {
            float notesFrq = (float)this.currentNote.getFrequency();
            this.setSI(notesFrq *= this.frqRatio);
        } else {
            this.frq *= this.frqRatio;
            this.setSI(this.frq);
        }
    }

    public void setChoice(int choiceVal) {
        this.choice = choiceVal;
    }

    public void setAmp(float amp) {
        this.amp = amp;
        this.choice = 0;
    }

    public float getAmp() {
        return this.amp;
    }

    public void setFrq(float frq) {
        this.frq = frq;
        this.choice = 1;
    }

    public void setFrqRatio(double frqRatio) {
        this.frqRatio = (float)frqRatio;
    }

    protected void setSI(double frequency) {
        this.si = (float)Math.PI * 2 / ((float)this.sampleRate / (float)frequency);
    }

    protected float getWaveSample() {
        switch (this.waveType) {
            case 0: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float sample = (float)Math.sin(this.phase + (float)Math.PI * 2);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 1: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float sample = (float)Math.cos(this.phase + (float)Math.PI * 2);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 2: {
                float position;
                float sample = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                if ((position = 0.15915494f * this.phase) <= 0.25f) {
                    sample = (float)((double)position * 4.0);
                }
                if (position > 0.25f && position <= 0.75f) {
                    sample = (float)(4.0 * (0.5 - (double)position));
                }
                if (position > 0.75f) {
                    sample = (float)(((double)position - 1.0) * 4.0);
                }
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 3: {
                float position;
                float sample = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                sample = (position = 0.15915494f * this.phase) < 0.5f ? 1.0f : -1.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 4: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float position = 0.31830987f * this.phase;
                float sample = (float)((double)position - 1.0);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 5: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float position = 0.31830987f * this.phase;
                float sample = (float)(1.0 - (double)position);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 6: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float position = 0.15915494f * this.phase;
                float sample = (float)Math.exp(position) - 2.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 7: {
                float position;
                float sample = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                sample = (position = 0.15915494f * this.phase) < (float)this.pulseWidth ? 1.0f : -1.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
        }
        System.err.println("Incorrect oscillator type selected.");
        System.exit(1);
        return 0.0f;
    }

    public void setPulseWidth(double width) {
        if (width >= 0.0 && width <= 1.0) {
            this.pulseWidth = width;
        } else {
            System.err.println("Pulse wide must be between 0.0 and 1.0");
        }
    }

    public void setPhase(double phase) {
        this.phase = (float)phase;
    }
}

