/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import java.util.Random;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class Noise
extends AudioObject {
    private int noiseType = 0;
    private int noiseDensity = 10;
    private float amp = 1.0f;
    private static float sum;
    private static float[] rg;
    private static int k;
    private static int kg;
    private static int ng;
    private static int threshold;
    private static int np;
    private static int nbits;
    private static int numbPoints;
    private static float nr;
    private static float result;
    private static int counter;
    private double standardDeviation = 0.25;
    private double mean = 0.0;
    private float walkLastValue = 0.0f;
    private float walkStepSize = 0.3f;
    private float walkMax = 1.0f;
    private float walkMin = -1.0f;
    private int walkNoiseDensity = 500;
    private long walkDensityCounter = 0L;
    private boolean walkVaryDensity = true;
    private int walkNoiseDensityMin = 1;
    private int walkNoiseDensityMax = 1500;
    private int walkNoiseDensityStepSize = 100;
    private int gendynAmpGranularity = 100;
    private int gendynPrevTime = 50;
    private int gendynTimeMirror = 100;
    private int gendynAmpMirror = 80;
    private int gendynAmp0 = 0;
    private int gendynTime1 = 50;
    private int gendynAmp1 = 0;
    private int gendynTime2 = 50;
    private int gendynAmp2 = 0;
    private int gendynTime3 = 50;
    private int gendynAmp3 = 0;
    private int[] gendynIntArray;
    private int gendynIntArrayLength;
    private int gendynIntArrayCounter = 0;
    private int gendynTimeStepSize = 4;
    private int maxGendynTimeStepSize = 75;
    private int gendynAmpStepSize = 2;
    private int maxGendynAmpStepSize = 10;
    private boolean gendynGaussian = false;
    private int gendynPrimaryTimeStepSize = 10;
    private int gendynPrimaryAmpStepSize = 10;
    private int gendynPrimaryTimeMirror = 100;
    private int gendynPrimaryAmpMirror = 100;
    public static final int WHITE_NOISE = 0;
    public static final int STEP_NOISE = 1;
    public static final int SMOOTH_NOISE = 2;
    public static final int BROWN_NOISE = 3;
    public static final int FRACTAL_NOISE = 4;
    public static final int GAUSSIAN_NOISE = 5;
    public static final int WALK_NOISE = 6;
    public static final int GENDYN_NOISE = 7;

    static {
        rg = new float[16];
        np = 1;
        nbits = 1;
        numbPoints = 48000;
        nr = numbPoints;
        counter = 0;
    }

    public Noise(Instrument inst) {
        this(inst, 0);
    }

    public Noise(Instrument inst, int noiseType) {
        this(inst, noiseType, 44100);
    }

    public Noise(Instrument inst, int noiseType, int sampleRate) {
        this(inst, noiseType, sampleRate, 1);
    }

    public Noise(Instrument inst, int noiseType, int sampleRate, int channels) {
        super(inst, sampleRate, "[WaveTable]");
        this.noiseType = noiseType;
        this.channels = channels;
        if (noiseType == 4) {
            this.setUpFractalMath();
        }
        if (noiseType == 7) {
            this.makeGendynArray();
        }
    }

    public void setAmp(float amp) {
        this.amp = amp;
    }

    public float getAmp() {
        return this.amp;
    }

    private void setUpFractalMath() {
        nr /= 2.0f;
        while (nr > 1.0f) {
            ++nbits;
            np *= 2;
            nr /= 2.0f;
        }
        kg = 0;
        while (kg < nbits) {
            Noise.rg[Noise.kg] = (float)Math.random();
            ++kg;
        }
    }

    public int work(float[] buffer) throws AOException {
        int ret = 0;
        switch (this.noiseType) {
            case 0: {
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        buffer[ret++] = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        ++j;
                    }
                }
                break;
            }
            case 3: {
                float prev0 = 0.0f;
                float prev1 = 0.0f;
                float prev2 = 0.0f;
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        float current = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        float brownValue = (prev0 + prev1 + prev2 + current) / 4.0f;
                        buffer[ret++] = brownValue;
                        prev0 = prev1;
                        prev1 = prev2;
                        prev2 = current;
                        ++j;
                    }
                }
                break;
            }
            case 1: {
                int density = this.noiseDensity;
                float temp = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        if (ret % density == 0) {
                            temp = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        }
                        buffer[ret++] = temp;
                        ++j;
                    }
                }
                break;
            }
            case 2: {
                int density = this.noiseDensity;
                float temp = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                float temp2 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        if ((ret + 1) % density == 0) {
                            buffer[ret++] = temp2;
                            temp = temp2;
                            temp2 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        } else {
                            buffer[ret++] = temp + (temp2 - temp) / (float)density * (float)(ret % density);
                        }
                        ++j;
                    }
                }
                break;
            }
            case 4: {
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        if (counter % this.noiseDensity == 0) {
                            threshold = np;
                            ng = nbits;
                            while (k % threshold != 0) {
                                --ng;
                                threshold /= 2;
                            }
                            sum = 0.0f;
                            kg = 0;
                            while (kg < nbits) {
                                if (kg < ng) {
                                    Noise.rg[Noise.kg] = (float)Math.random();
                                }
                                sum += rg[kg];
                                ++kg;
                            }
                            result = (float)(((double)(sum / (float)nbits) - 0.17) * 2.85 - 1.0);
                            if ((double)result > 1.0) {
                                result = 1.0f;
                            } else if ((double)result < -1.0) {
                                result = -1.0f;
                            }
                        }
                        ++counter;
                        buffer[ret++] = result * this.amp;
                        ++j;
                    }
                    if (counter <= 67000) continue;
                    counter = 0;
                }
                break;
            }
            case 5: {
                Random RNG = new Random();
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        float gaussValue = (float)(RNG.nextGaussian() * this.standardDeviation + this.mean);
                        if (gaussValue < -1.0f) {
                            gaussValue = -1.0f;
                        } else if (gaussValue > 1.0f) {
                            gaussValue = 1.0f;
                        }
                        buffer[ret++] = gaussValue * this.amp;
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        buffer[ret++] = this.walkLastValue;
                        ++this.walkDensityCounter;
                        if ((int)this.walkDensityCounter % this.walkNoiseDensity == 0) {
                            this.walkLastValue += (float)Math.random() * this.walkStepSize * 2.0f - this.walkStepSize;
                            while (this.walkLastValue > this.walkMax || this.walkLastValue < this.walkMin) {
                                if (this.walkLastValue > this.walkMax) {
                                    this.walkLastValue -= (this.walkLastValue - this.walkMax) * 2.0f;
                                }
                                if (!(this.walkLastValue < this.walkMin)) continue;
                                this.walkLastValue += (this.walkMin - this.walkLastValue) * 2.0f;
                            }
                            if (this.walkVaryDensity) {
                                this.walkNoiseDensity += (int)(Math.random() * (double)this.walkNoiseDensityStepSize * 2.0 - (double)this.walkNoiseDensityStepSize);
                                if (this.walkNoiseDensity < this.walkNoiseDensityMin) {
                                    this.walkNoiseDensity = this.walkNoiseDensityMin;
                                } else if (this.walkNoiseDensity > this.walkNoiseDensityMax) {
                                    this.walkNoiseDensity = this.walkNoiseDensityMax;
                                }
                            }
                        }
                        ++j;
                    }
                }
                break;
            }
            case 7: {
                while (ret < buffer.length) {
                    int j = 0;
                    while (j < this.channels) {
                        buffer[ret++] = (float)((double)this.gendynIntArray[this.gendynIntArrayCounter] * 4.0 / (double)this.gendynAmpMirror);
                        ++j;
                    }
                    ++this.gendynIntArrayCounter;
                    if (this.gendynIntArrayCounter < this.gendynIntArrayLength) continue;
                    this.makeGendynArray();
                }
                break;
            }
            default: {
                System.err.println(String.valueOf(this.name) + "jMusic error: Noise type " + this.noiseType + " not supported yet.");
                System.exit(1);
            }
        }
        return ret;
    }

    private void makeGendynArray() {
        this.gendynTimeStepSize = this.randWalk(this.gendynTimeStepSize, this.gendynPrimaryTimeStepSize, this.gendynPrimaryTimeMirror);
        if (Math.abs(this.gendynTimeStepSize) > this.maxGendynTimeStepSize) {
            this.gendynTimeStepSize = this.maxGendynTimeStepSize;
        }
        this.gendynAmpStepSize = this.randWalk(this.gendynAmpStepSize, this.gendynPrimaryAmpStepSize, this.gendynPrimaryAmpMirror);
        if (Math.abs(this.gendynAmpStepSize) > this.maxGendynAmpStepSize) {
            this.gendynAmpStepSize = this.maxGendynAmpStepSize;
        }
        this.gendynTime1 = Math.abs(this.randWalk(this.gendynTime1, this.gendynTimeStepSize, this.gendynTimeMirror));
        this.gendynAmp1 = this.randWalk(this.gendynAmp1, this.gendynAmpStepSize, this.gendynAmpMirror);
        this.gendynTime2 = Math.abs(this.randWalk(this.gendynTime2, this.gendynTimeStepSize, this.gendynTimeMirror));
        this.gendynAmp2 = this.randWalk(this.gendynAmp2, this.gendynAmpStepSize, this.gendynAmpMirror);
        this.gendynTime3 = Math.abs(this.randWalk(this.gendynTime3, this.gendynTimeStepSize, this.gendynTimeMirror));
        this.gendynAmp3 = this.randWalk(this.gendynAmp3, this.gendynAmpStepSize, this.gendynAmpMirror);
        this.gendynIntArrayLength = this.gendynTime1 + this.gendynTime2 + this.gendynTime3;
        this.gendynIntArray = new int[this.gendynIntArrayLength];
        int counter = 0;
        int inc = (this.gendynAmp1 - this.gendynAmp0) / this.gendynTime1;
        int i = 0;
        while (i < this.gendynTime1) {
            this.gendynIntArray[counter++] = this.gendynAmp0 + inc * i;
            ++i;
        }
        inc = (this.gendynAmp2 - this.gendynAmp1) / this.gendynTime2;
        i = 0;
        while (i < this.gendynTime2) {
            this.gendynIntArray[counter++] = this.gendynAmp1 + inc * i;
            ++i;
        }
        inc = (this.gendynAmp3 - this.gendynAmp2) / this.gendynTime3;
        i = 0;
        while (i < this.gendynTime3) {
            this.gendynIntArray[counter++] = this.gendynAmp2 + inc * i;
            ++i;
        }
        this.gendynAmp0 = this.gendynAmp3;
        this.gendynIntArrayCounter = 0;
    }

    private int randWalk(int prevVal, int stepSize, int mirror) {
        int newVal = 0;
        if (this.gendynGaussian) {
            Random RNG = new Random();
            newVal = prevVal + (int)(RNG.nextGaussian() * (double)stepSize * 2.0 - (double)stepSize);
        } else {
            newVal = prevVal + (int)(Math.random() * (double)stepSize * 2.0 - (double)stepSize);
        }
        while (newVal > mirror || newVal < mirror * -1) {
            if (newVal > mirror) {
                newVal -= (newVal - mirror) * 2;
            }
            if (newVal >= mirror * -1) continue;
            newVal += (mirror * -1 - newVal) * 2;
        }
        if (newVal <= 0) {
            newVal = 1;
        }
        return newVal;
    }

    public void setNoiseDensity(int newDensity) {
        this.noiseDensity = newDensity;
    }

    public void setStandardDeviation(double newValue) {
        this.standardDeviation = newValue;
    }

    public void setMean(double newValue) {
        this.mean = newValue;
    }

    public void setWalkStepSize(double val) {
        if (val > 0.0) {
            this.walkStepSize = (float)val;
        } else {
            System.err.println("Walk step size must be greater than zero.");
        }
    }

    public void setWalkMax(double val) {
        if (val > 0.0) {
            this.walkMax = (float)val;
        } else {
            System.err.println("Walk maximum value must be greater than zero.");
        }
    }

    public void setWalkMin(double val) {
        if (val < 0.0) {
            this.walkMin = (float)val;
        } else {
            System.err.println("Walk minimum value must be less than zero.");
        }
    }

    public void setWalkNoiseDensity(int val) {
        if (val > 0) {
            this.walkNoiseDensity = val;
        } else {
            System.err.println("walkNoiseDensity must be greater than zero.");
        }
    }

    public void setWalkVaryDensity(boolean val) {
        this.walkVaryDensity = val;
    }

    public void setWalkNoiseDensityMin(int val) {
        if (val > 0) {
            this.walkNoiseDensityMin = val;
        } else {
            System.err.println("walkNoiseDensityMin must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityMax(int val) {
        if (val > 0) {
            this.walkNoiseDensityMax = val;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityStepSize(int val) {
        if (val > 0) {
            this.walkNoiseDensityStepSize = val;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setGendynTimeMirror(double newVal) {
        if (newVal > 0.0) {
            this.gendynTimeMirror = (int)newVal;
        }
    }

    public void setGendynAmpMirror(double newVal) {
        if (newVal > 0.0) {
            this.gendynAmpMirror = (int)newVal;
        }
    }

    public int getGendynAmp0() {
        return this.gendynAmp0;
    }

    public int getGendynAmp1() {
        return this.gendynAmp1;
    }

    public int getGendynAmp2() {
        return this.gendynAmp2;
    }

    public int getGendynAmp3() {
        return this.gendynAmp3;
    }

    public int getGendynTime1() {
        return this.gendynTime1;
    }

    public int getGendynTime2() {
        return this.gendynTime2;
    }

    public int getGendynTime3() {
        return this.gendynTime3;
    }

    public int getGendynAmpStepSize() {
        return this.gendynAmpStepSize;
    }

    public int getGendynTimeStepSize() {
        return this.gendynTimeStepSize;
    }

    public void setGendynAmpStepSize(int val) {
        if (val >= 0) {
            this.gendynAmpStepSize = val;
        }
    }

    public void setMaxGendynAmpStepSize(int val) {
        if (val >= 0) {
            this.maxGendynAmpStepSize = val;
        }
    }

    public void setGendynTimeStepSize(int val) {
        if (val >= 0) {
            this.gendynTimeStepSize = val;
        }
    }

    public void setMaxGendynTimeStepSize(int val) {
        if (val >= 0) {
            this.maxGendynTimeStepSize = val;
        }
    }

    public void setGendynPrimaryAmpStepSize(int val) {
        if (val >= 0) {
            this.gendynPrimaryAmpStepSize = val;
        }
    }

    public void setGendynPrimaryTimeStepSize(int val) {
        if (val >= 0) {
            this.gendynPrimaryTimeStepSize = val;
        }
    }

    public void setGendynAmpGranularity(int val) {
        if (val > 0) {
            this.gendynAmpGranularity = val;
        }
    }

    public void setGendynPrimaryTimeMirror(int val) {
        if (val >= 0) {
            this.gendynPrimaryTimeMirror = val;
        }
    }

    public void setGendynPrimaryAmpMirror(int val) {
        if (val >= 0) {
            this.gendynPrimaryAmpMirror = val;
        }
    }

    public void setGendynGaussian(boolean val) {
        this.gendynGaussian = val;
    }
}

