/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

public class MassObject {
    private double massSize = 1.0;
    private double friction = 3.0E-6;
    private double inertia = 0.0;
    private double deltaTime = 1.0;
    private double yPosition;

    public MassObject() {
        this(1.0);
    }

    public MassObject(double friction) {
        this(friction, 1.0);
    }

    public MassObject(double friction, double size) {
        this.massSize = size;
        this.friction = friction;
    }

    public void setYPosition(double newPos) {
        this.yPosition = newPos;
    }

    public double getYPosition() {
        return this.yPosition;
    }

    public double getDisplacement(double force) {
        force += this.inertia;
        if (this.inertia < 0.0 && this.friction > 0.0 || this.inertia > 0.0 && this.friction < 0.0) {
            this.friction *= -1.0;
        }
        this.inertia = Math.abs(this.friction) > Math.abs(force) ? 0.0 : force - this.friction;
        double accel = force / this.massSize;
        double displacement = accel / (this.deltaTime * this.deltaTime);
        return displacement;
    }
}

