/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Filter
extends AudioObject {
    public static final int LOW_PASS = 0;
    public static final int HIGH_PASS = 1;
    private int type = 0;
    private double cutoff_frequency;
    private double initialCutoff;
    private double cutoff_frq_percent;
    private double ripple = 0.5;
    private double poles = 2.0;
    private double[] a = new double[22];
    private double[] ta = new double[22];
    private double[] b = new double[22];
    private double[] tb = new double[22];
    private double[][] xbuf;
    private double[][] ybuf;

    public Filter(AudioObject ao, double freq) {
        this(ao, freq, 0, 0.5, 2.0);
    }

    public Filter(AudioObject ao, double freq, int type) {
        this(ao, freq, type, 0.5, 2.0);
    }

    public Filter(AudioObject ao, double freq, int type, double ripple, double poles) {
        super(ao, "[Filter]");
        this.type = type;
        this.cutoff_frequency = freq;
        this.ripple = ripple;
        this.poles = poles;
        if (this.poles > 20.0) {
            System.err.println("More than 20 poles are not allowed (Sorry)");
            System.exit(1);
        }
    }

    public Filter(AudioObject[] aoArray, double freq, int type) {
        this(aoArray, freq, type, 0.5, 2.0);
    }

    public Filter(AudioObject[] aoArray, double freq, int type, double ripple, double poles) {
        super(aoArray, "[Filter]");
        this.type = type;
        this.cutoff_frequency = freq;
        this.initialCutoff = freq;
        this.ripple = ripple;
        this.poles = poles;
        if (this.poles > 20.0) {
            System.err.println("More than 20 poles are not allowed (Sorry)");
            System.exit(1);
        }
    }

    public void build() {
        this.ybuf = new double[this.channels][22];
        this.xbuf = new double[this.channels][22];
        this.setCutOff(this.cutoff_frequency);
    }

    public void printCoefficients() {
        int i = 0;
        while (i < 22) {
            System.out.println("a[" + i + "] " + this.a[i] + "    b[" + i + "] " + this.b[i]);
            ++i;
        }
    }

    public void setCutOff(double freq) {
        this.cutoff_frequency = freq;
        if (freq <= 0.0) {
            System.err.println("Filter error: You tried to use a cuttoff frequency of " + freq + " - woops! Frequency must be greater than zero. ");
            System.err.println("Exiting from Filter");
            System.exit(1);
        }
        if (freq > 0.5 * (double)this.sampleRate) {
            System.err.println("Cutoff frequencies above the Nyquist limit are BAD ;) SampleRate = " + this.sampleRate + " Frequency = " + freq);
            System.err.println("Exiting from Filter");
            System.exit(1);
        }
        this.cutoff_frq_percent = 1.0 / (double)this.sampleRate * freq;
        this.coefficientCalc();
    }

    public void setPoles(int newPole) {
        if (newPole < 0) {
            newPole = 0;
        }
        if (newPole > 20) {
            newPole = 20;
        }
        this.poles = newPole;
        this.setCutOff(this.cutoff_frequency);
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].nextWork(buffer);
        float[] cutoffs = null;
        if (this.previous.length > 1) {
            cutoffs = new float[returned];
            this.previous[1].nextWork(cutoffs);
        }
        int i = 0;
        int chan = 0;
        while (i < returned) {
            if (i % 100 == 0 && this.previous.length > 1) {
                this.setCutOff((double)cutoffs[i] + this.initialCutoff);
            }
            int j = (int)this.poles;
            while (j > 0) {
                this.xbuf[chan][j] = this.xbuf[chan][j - 1];
                --j;
            }
            this.xbuf[chan][0] = buffer[i];
            j = (int)this.poles;
            while (j > 0) {
                this.ybuf[chan][j] = this.ybuf[chan][j - 1];
                --j;
            }
            this.ybuf[chan][0] = 0.0;
            j = 0;
            while ((double)j < this.poles + 1.0) {
                double[] dArray = this.ybuf[chan];
                dArray[0] = dArray[0] + this.a[j] * this.xbuf[chan][j];
                if (j > 0) {
                    double[] dArray2 = this.ybuf[chan];
                    dArray2[0] = dArray2[0] + this.b[j] * this.ybuf[chan][j];
                }
                ++j;
            }
            buffer[i] = (float)(this.ybuf[chan][0] * 1.0);
            if (this.channels == ++chan) {
                chan = 0;
            }
            ++i;
        }
        return i;
    }

    public void coefficientCalc() {
        int i = 0;
        while (i < 22) {
            this.a[i] = 0.0;
            this.b[i] = 0.0;
            ++i;
        }
        this.a[2] = 1.0;
        this.b[2] = 1.0;
        int p = 1;
        while ((double)p <= this.poles * 0.5) {
            double[] nums = this.coefficientCalcSupport(p);
            int i2 = 0;
            while (i2 < 22) {
                this.ta[i2] = this.a[i2];
                this.tb[i2] = this.b[i2];
                ++i2;
            }
            i2 = 2;
            while (i2 < 22) {
                this.a[i2] = nums[0] * this.ta[i2] + nums[1] * this.ta[i2 - 1] + nums[2] * this.ta[i2 - 2];
                this.b[i2] = this.tb[i2] - nums[3] * this.tb[i2 - 1] - nums[4] * this.tb[i2 - 2];
                ++i2;
            }
            ++p;
        }
        this.b[2] = 0.0;
        i = 0;
        while (i < 20) {
            this.a[i] = this.a[i + 2];
            this.b[i] = -this.b[i + 2];
            ++i;
        }
        double sa = 0.0;
        double sb = 0.0;
        int i3 = 0;
        while (i3 < 20) {
            if (this.type == 0) {
                sa += this.a[i3];
            }
            if (this.type == 0) {
                sb += this.b[i3];
            }
            if (this.type == 1) {
                sa += this.a[i3] * Math.pow(-1.0, i3);
            }
            if (this.type == 1) {
                sb += this.b[i3] * Math.pow(-1.0, i3);
            }
            ++i3;
        }
        double gain = sa / (1.0 - sb);
        int i4 = 0;
        while (i4 < 20) {
            this.a[i4] = this.a[i4] / gain;
            ++i4;
        }
    }

    private double[] coefficientCalcSupport(int p) {
        double[] returns = new double[5];
        double RP = -Math.cos(Math.PI / (this.poles * 2.0) + (double)(p - 1) * Math.PI / this.poles);
        double IP = Math.sin(Math.PI / (this.poles * 2.0) + (double)(p - 1) * Math.PI / this.poles);
        if (this.ripple != 0.0) {
            double ES = Math.sqrt(Math.pow(100.0 / (100.0 - this.ripple), 2.0) - 1.0);
            double VX = 1.0 / this.poles * Math.log(1.0 / ES + Math.sqrt(1.0 / (ES * ES) + 1.0));
            double KX = 1.0 / this.poles * Math.log(1.0 / ES + Math.sqrt(1.0 / (ES * ES) - 1.0));
            KX = (Math.exp(KX) + Math.exp(-KX)) * 0.5;
            RP = RP * ((Math.exp(VX) - Math.exp(-VX)) * 0.5) / KX;
            IP = IP * ((Math.exp(VX) + Math.exp(-VX)) * 0.5) / KX;
        }
        double T = 2.0 * Math.tan(0.5);
        double W = Math.PI * 2 * this.cutoff_frq_percent;
        double M = RP * RP + IP * IP;
        double D = 4.0 - 4.0 * RP * T + M * (T * T);
        double X0 = T * T / D;
        double X1 = 2.0 * X0;
        double X2 = X0;
        double Y1 = (8.0 - 2.0 * M * (T * T)) / D;
        double Y2 = (-4.0 - 4.0 * RP * T - M * (T * T)) / D;
        double K = 0.0;
        if (this.type == 1) {
            K = -Math.cos(W * 0.5 + 0.5) / Math.cos(W * 0.5 - 0.5);
        }
        if (this.type == 0) {
            K = Math.sin(0.5 - W * 0.5) / Math.sin(0.5 + W * 0.5);
        }
        D = 1.0 + Y1 * K - Y2 * (K * K);
        returns[0] = (X0 - X1 * K + X2 * (K * K)) / D;
        returns[1] = (-2.0 * X0 * K + X1 + X1 * (K * K) - 2.0 * X2 * K) / D;
        returns[2] = (X0 * (K * K) - X1 * K + X2) / D;
        returns[3] = (2.0 * K + Y1 + Y1 * (K * K) - 2.0 * Y2 * K) / D;
        returns[4] = (-(K * K) - Y1 * K + Y2) / D;
        if (this.type == 1) {
            returns[1] = -returns[1];
        }
        if (this.type == 1) {
            returns[3] = -returns[3];
        }
        return returns;
    }
}

