/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.EnvPoint;

public class Envelope
extends AudioObject
implements JMC {
    private EnvPoint[] graphPoints;
    private float[] graphShape;
    private int position = 1;
    private boolean primary;
    private boolean useNotePoints = false;
    private int notePointIndex;

    public Envelope(Instrument inst, int sampleRate, int channels, EnvPoint[] graphPoints) {
        super(inst, sampleRate, "[Envelope]");
        this.channels = channels;
        this.graphPoints = graphPoints;
        this.primary = true;
    }

    public Envelope(Instrument inst, int sampleRate, int channels, double[] breakPoints) {
        super(inst, sampleRate, "[Envelope]");
        this.channels = channels;
        this.breakPointsToGraphPoints(breakPoints);
        this.primary = true;
    }

    public Envelope(Instrument inst, int sampleRate, int channels, int notePointIndex) {
        super(inst, sampleRate, "[Envelope]");
        this.channels = channels;
        this.useNotePoints = true;
        this.notePointIndex = notePointIndex;
        this.primary = true;
    }

    public Envelope(AudioObject ao) {
        super(ao, "[Envelope]");
        this.useNotePoints = true;
        this.notePointIndex = 0;
        this.primary = false;
    }

    public Envelope(AudioObject ao, int notePointIndex) {
        super(ao, "[Envelope]");
        this.useNotePoints = true;
        this.notePointIndex = notePointIndex;
        this.primary = false;
    }

    public Envelope(AudioObject ao, EnvPoint[] graphPoints) {
        super(ao, "[Envelope]");
        this.graphPoints = graphPoints;
        this.primary = false;
    }

    public Envelope(AudioObject ao, double[] breakPoints) {
        super(ao, "[Envelope]");
        this.breakPointsToGraphPoints(breakPoints);
        this.primary = false;
    }

    private void breakPointsToGraphPoints(double[] breakPoints) {
        this.graphPoints = new EnvPoint[breakPoints.length / 2];
        int counter = 0;
        int i = 0;
        while (i < breakPoints.length / 2) {
            this.graphPoints[i] = new EnvPoint((float)breakPoints[counter], (float)breakPoints[counter + 1]);
            counter += 2;
            ++i;
        }
    }

    public int work(float[] buffer) throws AOException {
        if (this.finished && this.inst.iterations <= 0) {
            return buffer.length;
        }
        if (this.primary) {
            int returned = buffer.length;
            int chancount = 1;
            int i = 0;
            while (i < returned) {
                try {
                    buffer[i] = this.graphShape[this.position];
                }
                catch (ArrayIndexOutOfBoundsException aob) {
                    buffer[i] = 0.0f;
                }
                if (chancount == this.channels) {
                    chancount = 1;
                    ++this.position;
                } else {
                    ++chancount;
                }
                ++i;
            }
            return returned;
        }
        int returned = this.previous[0].nextWork(buffer);
        int chancount = 1;
        int i = 0;
        while (i < returned) {
            try {
                buffer[i] = buffer[i] * this.graphShape[this.position];
            }
            catch (ArrayIndexOutOfBoundsException aob) {
                buffer[i] = 0.0f;
            }
            if (chancount == this.channels) {
                chancount = 1;
                ++this.position;
            } else {
                ++chancount;
            }
            ++i;
        }
        return returned;
    }

    public void build() {
        if (this.numOfSamples <= this.graphPoints.length * 4) {
            this.graphShape = new float[this.numOfSamples];
            int i = 0;
            while (i < this.numOfSamples) {
                this.graphShape[i] = 1.0f;
                ++i;
            }
            return;
        }
        if (this.useNotePoints) {
            this.breakPointsToGraphPoints(this.currentNote.getBreakPoints(this.notePointIndex));
        }
        if ((double)this.graphPoints[0].x != -1.0) {
            int i = 0;
            while (i < this.graphPoints.length) {
                this.graphPoints[i].X = (int)((float)this.numOfSamples * this.graphPoints[i].x);
                --this.graphPoints[i].X;
                ++i;
            }
        }
        this.graphShape = new float[this.numOfSamples];
        int j = 0;
        int i = 0;
        while (i < this.graphPoints.length - 1) {
            float gradient = (this.graphPoints[i].y - this.graphPoints[i + 1].y) / (float)(this.graphPoints[i].X - this.graphPoints[i + 1].X);
            float yintercept = this.graphPoints[i + 1].y - gradient * (float)this.graphPoints[i + 1].X;
            while (true) {
                this.graphShape[j] = gradient * (float)j + yintercept;
                if (j == this.graphPoints[i + 1].X) break;
                ++j;
            }
            ++i;
        }
        this.position = 0;
    }
}

