/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Compressor
extends AudioObject {
    private float threshold = 1.0f;
    private double ratio = 1.0;
    private float gainReduction = 1.0f;
    private float gain = 1.0f;

    public Compressor(AudioObject ao) {
        this(ao, 0.5);
    }

    public Compressor(AudioObject ao, double thresh) {
        this(ao, thresh, 2.0);
    }

    public Compressor(AudioObject ao, double thresh, double ratio) {
        this(ao, thresh, ratio, 1.5);
    }

    public Compressor(AudioObject ao, double thresh, double ratio, double gain) {
        super(ao, "[Compressor]");
        this.threshold = (float)thresh;
        this.ratio = ratio;
        this.gain = (float)gain;
        this.calcGainReduction();
    }

    public void build() {
    }

    private void calcGainReduction() {
        if (this.ratio == 1.0) {
            this.gainReduction = 1.0f;
        } else if (this.ratio > 1.0) {
            this.gainReduction = (float)Math.min(1.0, Math.abs(Math.log(1.0 - 1.0 / this.ratio) * 0.2));
        } else if (this.ratio > 0.0) {
            this.gainReduction = (float)(1.0 / this.ratio);
        } else {
            System.out.println("jMusic error: Compressor ratio values cannot be less than 0.0");
            System.exit(0);
        }
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].nextWork(buffer);
        int i = 0;
        while (i < returned) {
            if (buffer[i] > this.threshold) {
                buffer[i] = this.threshold + (buffer[i] - this.threshold) * this.gainReduction;
            }
            if (buffer[i] < -this.threshold) {
                buffer[i] = -this.threshold + (buffer[i] + this.threshold) * this.gainReduction;
            }
            int n = i++;
            buffer[n] = buffer[n] * this.gain;
        }
        return returned;
    }

    public void setThreshold(double thresh) {
        this.threshold = (float)thresh;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
        this.calcGainReduction();
    }

    public void setGain(double gain) {
        this.gain = (float)gain;
    }
}

