/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.EnvPoint;

public class ADSR
extends AudioObject
implements JMC {
    private EnvPoint[] graphPoints;
    private float[] graphShape;
    private boolean primary;
    private int attack;
    private int decay;
    private int release;
    private double sustain;
    private int totalSamples;
    private int sampleCounter = 0;
    private int position = 0;
    private double attackSamps;
    private double decaySamps;
    private double releaseSamps;
    private double prevRV = 0.0;
    int maxAttackCount;
    int maxDecayCount;

    public ADSR(Instrument inst, int sampleRate, int channels, int attack, int decay, double sustain, int release) {
        super(inst, sampleRate, "[ADSR]");
        this.channels = channels;
        this.attack = attack;
        this.decay = decay;
        this.sustain = sustain;
        this.release = release;
        this.primary = true;
        this.finished = false;
        this.calcSamps();
    }

    public ADSR(AudioObject ao, int attack, int decay, double sustain, int release) {
        super(ao, "[ADSR]");
        this.attack = attack;
        this.decay = decay;
        this.sustain = sustain;
        this.release = release;
        this.primary = false;
        this.finished = false;
    }

    public int work(float[] buffer) throws AOException {
        if (this.sampleCounter > this.totalSamples * this.channels) {
            this.finished = true;
        }
        if (this.primary) {
            int returned = buffer.length;
            int i = 0;
            while (i < returned) {
                int j = 0;
                while (j < this.channels) {
                    try {
                        buffer[i + j] = this.graphShape[this.position];
                    }
                    catch (ArrayIndexOutOfBoundsException aob) {
                        buffer[i + j] = 0.0f;
                    }
                    ++j;
                }
                ++this.position;
                ++i;
            }
            this.sampleCounter += buffer.length;
            return returned;
        }
        int returned = this.previous[0].nextWork(buffer);
        int i = 0;
        while (i < buffer.length) {
            int j = 0;
            while (j < this.channels) {
                try {
                    buffer[i + j] = this.sampleCounter < this.maxAttackCount ? buffer[i + j] * (float)((double)this.sampleCounter * 1.0 / (double)this.maxAttackCount) : (this.sampleCounter < this.maxDecayCount + this.maxAttackCount ? buffer[i + j] * (float)(1.0 - (double)(this.sampleCounter - this.maxAttackCount) * (1.0 - this.sustain) / (double)this.maxDecayCount) : (this.sampleCounter < this.numOfSamples ? buffer[i + j] * (float)this.sustain : (this.sampleCounter < this.totalSamples ? buffer[i + j] * (float)(this.sustain - (double)(this.sampleCounter - this.numOfSamples) * this.sustain / this.releaseSamps) : 0.0f)));
                }
                catch (ArrayIndexOutOfBoundsException aob) {
                    buffer[i + j] = 0.0f;
                }
                ++j;
            }
            ++this.sampleCounter;
            ++this.position;
            i += this.channels;
        }
        return returned;
    }

    private void calcSamps() {
        this.attackSamps = this.getSamps(this.attack);
        this.decaySamps = this.getSamps(this.decay);
        this.releaseSamps = this.getSamps(this.release);
    }

    private double getSamps(int milli) {
        return (double)milli / 1000.0 * (double)this.sampleRate;
    }

    public void build() {
        this.sampleCounter = 0;
        this.position = 0;
        if (this.numOfSamples == 0) {
            return;
        }
        if (this.currentNote.getRhythmValue() == this.prevRV) {
            return;
        }
        this.calcSamps();
        this.totalSamples = this.numOfSamples + (int)this.releaseSamps;
        this.graphShape = new float[this.totalSamples];
        this.maxAttackCount = Math.min((int)this.attackSamps, this.numOfSamples);
        double inc = 1.0 / (double)this.maxAttackCount;
        int i = 0;
        while (i < this.maxAttackCount) {
            this.graphShape[i] = (float)(inc * (double)i);
            ++i;
        }
        this.maxDecayCount = this.maxAttackCount;
        if (this.sustain < 1.0) {
            this.maxDecayCount = Math.min((int)this.attackSamps + (int)this.decaySamps, this.numOfSamples);
            double diff = (1.0 - this.sustain) / (double)(this.maxDecayCount - this.maxAttackCount);
            int i2 = this.maxAttackCount;
            while (i2 < this.maxDecayCount) {
                this.graphShape[i2] = (float)(1.0 - diff * (double)(i2 - this.maxAttackCount));
                ++i2;
            }
        }
        i = this.maxDecayCount;
        while (i < this.numOfSamples) {
            this.graphShape[i] = (float)this.sustain;
            ++i;
        }
        double startVal = this.graphShape[this.numOfSamples - 1];
        double inc2 = startVal / this.releaseSamps;
        int i3 = this.numOfSamples;
        while (i3 < this.totalSamples) {
            this.graphShape[i3] = (float)(startVal - inc2 * (double)(i3 - this.numOfSamples));
            ++i3;
        }
        this.finished = false;
    }
}

