/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;

public final class SampleOut
extends AudioObject
implements JMC {
    private boolean sync;
    public static float max = 0.0f;
    public static int numofchan;
    public static int samprate;
    private RandomAccessFile raf;
    private int position = 0;
    private int count;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private DataOutputStream dos = new DataOutputStream(this.bos);
    private boolean DEBUG_AU = false;
    private String fileName;
    private int size = 0;

    public SampleOut(AudioObject ao) {
        super(ao, "[SampleOut]");
        this.sync = true;
        this.fileName = "jmusic.tmp";
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public SampleOut(AudioObject ao, String fileName) {
        super(ao, "[SampleOut]");
        this.sync = true;
        this.fileName = fileName;
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public SampleOut(AudioObject ao, String fileName, boolean sync) {
        super(ao, "[SampleOut]");
        this.sync = sync;
        this.fileName = fileName;
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public SampleOut(AudioObject ao, String fileName, int position, boolean sync) {
        super(ao, "[SampleOut]");
        this.sync = sync;
        this.position = position;
        this.fileName = fileName;
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public void finalize() {
    }

    public void build() {
        if (this.sync) {
            try {
                this.raf.getFD().sync();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.position = (int)(this.currentNoteStartTime * (double)this.sampleRate) * 4 * this.channels;
        if (this.position < 0) {
            this.position = 0;
        }
        samprate = this.sampleRate;
        numofchan = this.channels;
        this.finished = false;
    }

    public int work(float[] buffer) throws AOException {
        if (this.inst.iterations < 0) {
            this.finished = true;
        }
        int returned = this.previous[0].nextWork(buffer);
        int i = 0;
        while (i < returned) {
            float sample = buffer[i];
            if (max < Math.abs(sample)) {
                max = Math.abs(sample);
            }
            try {
                this.dos.writeFloat(sample);
            }
            catch (IOException ioe) {
                throw new AOException(this.name, ioe.toString());
            }
            ++i;
        }
        this.write(returned);
        return returned;
    }

    private void write(int numof) {
        int numofloats = numof;
        ByteArrayInputStream bis = null;
        DataInputStream dis = null;
        ByteArrayInputStream bis2 = null;
        DataInputStream dis2 = null;
        int numofbytes = numofloats * 4;
        try {
            this.raf.seek(this.position);
            float f = this.raf.readFloat();
            this.raf.seek(this.position);
            byte[] inarray = new byte[numofbytes];
            int err = this.raf.read(inarray);
            bis = new ByteArrayInputStream(inarray);
            dis = new DataInputStream(bis);
            bis2 = new ByteArrayInputStream(this.bos.toByteArray());
            dis2 = new DataInputStream(bis2);
            this.bos.reset();
            float[] outsample = new float[numofloats];
            int i = 0;
            while (i < numofloats) {
                outsample[i] = dis.readFloat() + dis2.readFloat();
                if (max < Math.abs(outsample[i])) {
                    max = Math.abs(outsample[i]);
                }
                this.dos.writeFloat(outsample[i]);
                ++i;
            }
            this.dos.flush();
            this.raf.seek(this.position);
            this.raf.write(this.bos.toByteArray());
            this.bos.reset();
            this.position += numofbytes;
            dis.close();
            bis.close();
            dis2.close();
            bis2.close();
        }
        catch (EOFException eofe) {
            try {
                this.raf.seek(this.position);
                this.raf.write(this.bos.toByteArray());
                this.bos.reset();
                this.position += numofbytes;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

