/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public final class RTIn
extends AudioObject {
    public boolean finished = false;
    private int bufsize;
    private TargetDataLine dline;
    private boolean started = false;
    static /* synthetic */ Class class$0;

    public RTIn(Instrument inst, int sampleRate, int channels, int bufsize) {
        super(inst, sampleRate, "[RTIn]");
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.bufsize = bufsize;
        this.init();
    }

    public int work(float[] buffer) throws AOException {
        if (!this.started) {
            this.dline.start();
            this.started = true;
        }
        int ret = 0;
        int bc = 0;
        int amount = buffer.length * 2;
        byte[] data = new byte[amount];
        this.dline.read(data, 0, amount);
        while (ret < buffer.length) {
            short input = (short)((data[bc++] << 8) + data[bc++]);
            buffer[ret] = (float)input / 32767.0f;
            ++ret;
        }
        return ret;
    }

    public void init() {
        AudioFormat af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, this.channels, this.channels * 2, this.sampleRate, true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.TargetDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, af);
        System.out.println("Setting for audio line: " + info);
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println(info);
            System.err.println("JMF Line not supported ... exiting .. sothere");
            System.exit(1);
        }
        try {
            this.dline = (TargetDataLine)AudioSystem.getLine(info);
            this.dline.open(af, this.bufsize * 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

