/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AudioFileOut {
    private String fileName;
    private File file;
    private AudioFileFormat.Type fileType = AudioFileFormat.Type.AU;
    private AudioFormat format;
    private boolean bigEndian;
    private int channels;
    private int sampleRate;
    private long duration;
    private int sampleSize;
    private AudioInputStream ais;
    private float[] sampleData;

    public AudioFileOut(float[] sampleData, String fileName) {
        this(sampleData, fileName, 1, 44100, 16);
    }

    public AudioFileOut(float[] sampleData, String fileName, int channels, int sampleRate, int sampleSizeInBits) {
        this.sampleData = sampleData;
        this.duration = sampleData.length;
        this.fileName = fileName;
        this.channels = channels;
        this.sampleRate = sampleRate;
        this.sampleSize = sampleSizeInBits / 8;
        if (fileName.endsWith(".au")) {
            this.fileType = AudioFileFormat.Type.AU;
            this.bigEndian = true;
        } else if (fileName.endsWith(".wav")) {
            this.fileType = AudioFileFormat.Type.WAVE;
            this.bigEndian = false;
        } else if (fileName.endsWith(".aif") || fileName.endsWith(".aiff")) {
            this.fileType = AudioFileFormat.Type.AIFF;
            this.bigEndian = true;
        } else {
            fileName = String.valueOf(fileName) + ".au";
            this.bigEndian = true;
        }
        this.file = new File(this.fileName);
        byte[] tmp = new byte[sampleData.length * this.sampleSize];
        int i = 0;
        while (i < sampleData.length) {
            int ival = -1;
            switch (this.sampleSize) {
                case 1: {
                    tmp[i] = new Float(sampleData[i] * 127.0f).byteValue();
                    break;
                }
                case 2: {
                    short sval = new Float(sampleData[i] * 32767.0f).shortValue();
                    if (this.bigEndian) {
                        tmp[i * 2] = (byte)((sval & 0xFF00) >> 8);
                        tmp[i * 2 + 1] = (byte)(sval & 0xFF);
                        break;
                    }
                    tmp[i * 2] = (byte)(sval & 0xFF);
                    tmp[i * 2 + 1] = (byte)((sval & 0xFF00) >> 8);
                    break;
                }
                case 3: {
                    ival = new Float(sampleData[i] * 8388608.0f).intValue();
                    if (this.bigEndian) {
                        tmp[i * 3] = (byte)((ival & 0xFF0000) >> 16);
                        tmp[i * 3 + 1] = (byte)((ival & 0xFF00) >> 8);
                        tmp[i * 3 + 2] = (byte)(ival & 0xFF);
                        break;
                    }
                    tmp[i * 3] = (byte)(ival & 0xFF);
                    tmp[i * 3 + 1] = (byte)((ival & 0xFF00) >> 8);
                    tmp[i * 3 + 2] = (byte)((ival & 0xFF0000) >> 16);
                    break;
                }
                case 4: {
                    ival = new Float(sampleData[i] * 2.1474836E9f).intValue();
                    if (this.bigEndian) {
                        tmp[i * 4] = (byte)((ival & 0xFF000000) >> 24);
                        tmp[i * 4 + 1] = (byte)((ival & 0xFF0000) >> 16);
                        tmp[i * 4 + 2] = (byte)((ival & 0xFF00) >> 8);
                        tmp[i * 4 + 3] = (byte)(ival & 0xFF);
                        break;
                    }
                    tmp[i * 4] = (byte)(ival & 0xFF);
                    tmp[i * 4 + 1] = (byte)((ival & 0xFF00) >> 8);
                    tmp[i * 4 + 2] = (byte)((ival & 0xFF0000) >> 16);
                    tmp[i * 4 + 3] = (byte)((ival & 0xFF000000) >> 24);
                    break;
                }
                default: {
                    System.err.println("jMusic AudioFileOut error: " + sampleSizeInBits + " bit audio output file format not supported, sorry :(");
                    System.exit(0);
                }
            }
            ++i;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(tmp);
        this.format = new AudioFormat(this.sampleRate, sampleSizeInBits, this.channels, true, this.bigEndian);
        AudioInputStream ais = new AudioInputStream(bis, this.format, this.duration / (long)this.channels);
        try {
            AudioSystem.write(ais, this.fileType, this.file);
        }
        catch (IOException ioe) {
            System.out.println("error writing audio file.");
        }
    }
}

