/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileIn {
    private String fileName;
    private File file;
    private AudioFileFormat fileFormat;
    private AudioFormat format;
    private boolean bigEndian;
    private int channels;
    private int sampleRate;
    private long duration;
    private int sampleSize;
    private AudioInputStream is;
    private float[] sampleData;
    private boolean audioFileSpecified = true;

    public AudioFileIn(String fileName) {
        this.fileName = fileName;
        try {
            this.file = new File(fileName);
            this.fileFormat = AudioSystem.getAudioFileFormat(this.file);
            this.format = this.fileFormat.getFormat();
            this.bigEndian = this.format.isBigEndian();
            this.channels = this.format.getChannels();
            this.sampleRate = (int)this.format.getSampleRate();
            this.duration = (long)this.fileFormat.getFrameLength() * (long)this.channels;
            this.sampleSize = this.format.getSampleSizeInBits() / 8;
        }
        catch (UnsupportedAudioFileException uafe) {
            System.err.println("jMusic AudioFileIn warning: '" + fileName + "' may not be an audio file.");
            System.err.println("Reading it in as raw data...");
            this.audioFileSpecified = false;
            this.channels = 1;
            this.sampleSize = 1;
            this.sampleRate = 0;
        }
        catch (IOException ioe) {
            System.err.println("jMusic AudioFileIn error: Cannot read the specified file: " + fileName);
            System.err.println("Most likely the file does not exist at this location. Exiting...");
            System.exit(0);
        }
    }

    private void readFile() {
        if (this.audioFileSpecified) {
            try {
                this.is = AudioSystem.getAudioInputStream(this.file);
                byte[] tmp = new byte[(int)this.duration * this.sampleSize];
                this.is.read(tmp);
                this.is.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(tmp);
                this.sampleData = new float[(int)this.duration];
                byte[] sampleWord = new byte[this.sampleSize];
                int i = 0;
                while ((long)i < this.duration) {
                    if (bis.read(sampleWord) == -1) {
                        System.out.println("Ran out of samples to read");
                    } else {
                        this.sampleData[i] = this.getFloat(sampleWord);
                    }
                    ++i;
                }
                bis.close();
            }
            catch (UnsupportedAudioFileException tmp) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            Vector<Float> buffer = new Vector<Float>();
            try {
                FileInputStream fis = new FileInputStream(this.fileName);
                int val = fis.read();
                while (val != -1) {
                    buffer.addElement(new Float((float)val / 255.0f));
                    val = fis.read();
                }
                fis.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(1);
            }
            int max = buffer.size();
            this.sampleData = new float[max];
            int i = 0;
            while (i < max) {
                this.sampleData[i] = ((Float)buffer.elementAt(i)).floatValue();
                ++i;
            }
        }
    }

    public int getBitResolution() {
        int depth = -1;
        switch (this.sampleSize) {
            case 1: {
                depth = 8;
                break;
            }
            case 2: {
                depth = 16;
                break;
            }
            case 3: {
                depth = 24;
                break;
            }
            case 4: {
                depth = 32;
            }
        }
        return depth;
    }

    private float getFloat(byte[] b) {
        float sample = 0.0f;
        int ret = 0;
        int length = b.length;
        int i = 0;
        while (i < b.length) {
            ret |= (b[i] & 0xFF) << (this.bigEndian ? length : i + 1) * 8 - 8;
            ++i;
            --length;
        }
        switch (this.sampleSize) {
            case 1: {
                if (ret > 127) {
                    ret = ~ret + 1;
                    ret &= 0x7F;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 127.0f;
                break;
            }
            case 2: {
                if (ret > Short.MAX_VALUE) {
                    ret = ~ret + 1;
                    ret &= Short.MAX_VALUE;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 32767.0f;
                break;
            }
            case 3: {
                if (ret > 0x7FFFFF) {
                    ret = ~ret + 1;
                    ret &= 0x7FFFFF;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 8388608.0f;
                break;
            }
            case 4: {
                sample = (float)ret / 2.1474836E9f;
                break;
            }
            default: {
                System.err.println("Format not accepted");
            }
        }
        return sample;
    }

    public float[] getSampleData() {
        this.readFile();
        return this.sampleData;
    }

    public int getChannels() {
        return this.channels;
    }

    public String getFileType() {
        if (this.audioFileSpecified) {
            return this.fileFormat.toString();
        }
        return new String("Non-audio");
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleBitDepth() {
        return this.sampleSize * 8;
    }

    public String getEncoding() {
        return this.format.getEncoding().toString();
    }

    public int getDuration() {
        return (int)this.duration;
    }
}

