/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jm.audio.AudioChainListener;
import jm.audio.Instrument;
import jm.music.rt.RTLine;

public class RTMixer
implements AudioChainListener {
    private int totLines = 0;
    private int count = 0;
    private float[] sampleArray;
    private ByteArrayOutputStream bos;
    private DataOutputStream dos;
    private SourceDataLine dline;
    protected int sampleRate;
    protected int channels;
    public long currentTime = 0L;
    protected double controlRate = 0.05;
    private double scorePosition = 0.0;
    private RTLine[] rtlines;
    private int bufferSize;
    static /* synthetic */ Class class$0;

    public RTMixer(RTLine[] rtlines) {
        this.rtlines = rtlines;
        this.sampleRate = rtlines[0].getSampleRate();
        this.channels = rtlines[0].getChannels();
        this.bufferSize = (int)((double)(this.sampleRate * this.channels) * this.controlRate);
        while (this.bufferSize % 4 != 0) {
            this.controlRate += 0.001;
            this.bufferSize = (int)((double)(this.sampleRate * this.channels) * this.controlRate);
        }
        int i = 0;
        while (i < rtlines.length) {
            this.totLines += this.rtlines[i].getNumLines();
            this.rtlines[i].setBufferSize(this.bufferSize);
            if (rtlines[i].getSampleRate() != this.sampleRate) {
                System.err.println("jMusic RTMixer error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (rtlines[i].getChannels() != this.channels) {
                System.err.println("jMusic RTMixer error: All instruments must have the same number of channels.");
                System.exit(0);
            }
            ++i;
        }
        this.initJMFSound(this.bufferSize);
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
    }

    public synchronized void controlChange(float[] buffer, int returned, boolean finished) {
        int i = 0;
        while (i < returned) {
            int n = i;
            this.sampleArray[n] = this.sampleArray[n] + buffer[i];
            ++i;
        }
        if (++this.count == this.totLines) {
            this.scorePosition += this.controlRate;
            int j = 0;
            while (j < this.rtlines.length) {
                Instrument[] inst = this.rtlines[j].getInstrument();
                int i2 = 0;
                while (i2 < inst.length) {
                    inst[i2].release();
                    ++i2;
                }
                ++j;
            }
            this.count = 0;
            this.writeOutAudio(this.sampleArray.length);
        }
    }

    public void begin() {
        this.sampleArray = new float[this.bufferSize];
        int i = 0;
        while (i < this.rtlines.length) {
            this.rtlines[i].start(this.scorePosition, this);
            ++i;
        }
    }

    public void pause() {
        int i = 0;
        while (i < this.rtlines.length) {
            this.rtlines[i].pause();
            ++i;
        }
    }

    public void unPause() {
        int i = 0;
        while (i < this.rtlines.length) {
            this.rtlines[i].unPause();
            ++i;
        }
    }

    public void actionLines(Object obj, int actionNumber) {
        int i = 0;
        while (i < this.rtlines.length) {
            this.rtlines[i].externalAction(obj, actionNumber);
            ++i;
        }
    }

    private void writeOutAudio(int length) {
        this.bos.reset();
        int i = 0;
        while (i < length) {
            if (this.totLines > 1) {
                this.sampleArray[i] = this.sampleArray[i] / ((float)this.totLines * 0.75f);
            }
            try {
                this.dos.writeShort((short)(this.sampleArray[i] * 32767.0f));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.sampleArray[i] = 0.0f;
            ++i;
        }
        int returned = this.dline.write(this.bos.toByteArray(), 0, this.bos.size());
        this.currentTime += (long)length;
    }

    private void initJMFSound(int bufferSize) {
        DataLine.Info info;
        AudioFormat af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, this.channels, this.channels * 2, this.sampleRate, true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, af))) {
            System.out.println(info);
            System.err.println("jMusic RTMixer error: JMF Line not supported. Real time audio must be 16 bit stereo ... exiting .. so there : (");
            System.exit(1);
        }
        try {
            this.dline = (SourceDataLine)AudioSystem.getLine(info);
            this.dline.open(af, bufferSize * 8);
            this.dline.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finalize() {
        try {
            this.dos.close();
            this.bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

