/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioChainListener;
import jm.audio.AudioObject;
import jm.constants.Frequencies;
import jm.music.data.Note;
import jm.music.rt.RTLine;

public abstract class Instrument
extends Thread
implements Runnable,
JMC {
    public int iterations;
    protected Vector primaryAO;
    protected AudioObject finalAO = null;
    protected int numOfSamples = 0;
    protected int numOfChannels = 0;
    protected int bufsize = 4096;
    protected volatile Vector listeners = new Vector();
    protected long samplesProcessed = 0L;
    private boolean restNote = false;
    private float[] rtBuffer = new float[this.bufsize];
    private boolean finished = true;
    private boolean clear = false;
    private boolean block = true;
    private RTLine rtline;
    private int index = 0;
    public boolean finishedNewData = false;
    private boolean initialised = false;
    private boolean okToRun = true;
    public static final int RENDER = 0;
    public static final int REALTIME = 1;
    protected int output = 0;
    private int returned;
    private float[] buffer;

    protected Instrument() {
        this.primaryAO = new Vector();
    }

    public void renderNote(Note note, double startTime) {
        this.finalAO = null;
        Enumeration enume = this.primaryAO.elements();
        AudioObject pao = (AudioObject)this.primaryAO.elementAt(0);
        this.numOfSamples = (int)((float)pao.getSampleRate() * (float)note.getDuration());
        this.numOfChannels = pao.channels;
        if (note.getFrequency() == -2.147483648E9) {
            this.restNote = true;
        } else {
            double frequency = 0.0;
            frequency = !note.getPitchType() && note.getPitch() != Integer.MIN_VALUE ? Frequencies.FRQ[note.getPitch()] : note.getFrequency();
            if ((double)pao.getSampleRate() * 0.5 < frequency) {
                System.out.println("jMusic Instrument error: Sorry, can't render a note above the Nyquist frequency.");
                System.out.println("Sample rate = " + pao.getSampleRate() + " Pitch = " + note.getFrequency());
                System.exit(1);
            }
            this.restNote = false;
            while (enume.hasMoreElements()) {
                AudioObject ao = (AudioObject)enume.nextElement();
                ao.newNote(note, startTime - note.getOffset(), this.numOfSamples);
            }
        }
    }

    public void addPrimaryAO(AudioObject ao) {
        this.primaryAO.addElement(ao);
    }

    public void setFinalAO(AudioObject ao) throws AOException {
        if (this.finalAO != null && this.finalAO != ao) {
            throw new AOException("jMusic Instrument error: " + ao.name, String.valueOf(this.finalAO.name) + " is already set as finalAO.\n" + "  There can only be one finalAO.");
        }
        this.finalAO = ao;
    }

    public void setFinished(boolean state) {
        if (!this.finished) {
            return;
        }
        this.finished = state;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public void setBufSize(int bufsize) {
        this.bufsize = bufsize;
        this.rtBuffer = new float[bufsize];
    }

    public int getBufSize() {
        return this.bufsize;
    }

    public int getChannels() {
        try {
            if (!this.getInitialised()) {
                this.createChain();
                this.setInitialised(true);
            }
        }
        catch (AOException e) {
            e.printStackTrace();
        }
        return ((AudioObject)this.primaryAO.firstElement()).getChannels();
    }

    public int getSampleRate() {
        try {
            if (!this.getInitialised()) {
                this.createChain();
                this.setInitialised(true);
            }
        }
        catch (AOException e) {
            e.printStackTrace();
        }
        return ((AudioObject)this.primaryAO.firstElement()).getSampleRate();
    }

    public void setInitialised(boolean val) {
        this.initialised = val;
    }

    public boolean getInitialised() {
        return this.initialised;
    }

    public void addRTLine(RTLine rtline) {
        this.rtline = rtline;
    }

    public Enumeration getListeners() {
        return this.listeners.elements();
    }

    public void addAudioChainListener(AudioChainListener listener) {
        this.listeners.addElement(listener);
    }

    public void setController(double[] controlValues) {
    }

    public void run() {
        while (true) {
            this.finished = false;
            this.rtline.instNote(this, this.samplesProcessed);
            this.iterateChain();
        }
    }

    public void pause() {
        this.block();
    }

    public void unPause() {
        this.release();
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public void setClear(boolean clear) {
        this.clear = clear;
    }

    public void setOutput(int out) {
        this.output = out;
    }

    public int getOutput() {
        return this.output;
    }

    public synchronized void release() {
        this.notify();
        this.clear = true;
    }

    public synchronized void block() {
        if (!this.clear && this.block) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.clear = false;
    }

    public abstract void createChain() throws AOException;

    public void iterateChain() {
        this.iterations = 0;
        if (this.numOfSamples > 0) {
            this.iterations = this.numOfSamples * this.numOfChannels;
        }
        this.returned = 0;
        while (!this.finished) {
            int i;
            this.finished = true;
            this.buffer = null;
            if (this.iterations > this.bufsize || this.iterations <= 0) {
                this.buffer = new float[this.bufsize];
                i = 0;
                while (i < this.buffer.length) {
                    this.buffer[i] = 0.0f;
                    ++i;
                }
            } else {
                this.buffer = new float[this.iterations];
                i = 0;
                while (i < this.buffer.length) {
                    this.buffer[i] = 0.0f;
                    ++i;
                }
            }
            try {
                this.returned = this.restNote ? this.buffer.length : this.finalAO.nextWork(this.buffer);
            }
            catch (AOException aoe) {
                System.out.println(aoe);
                System.exit(1);
            }
            this.iterations -= this.returned;
            if (this.iterations > 0) {
                this.finished = false;
            }
            this.samplesProcessed += (long)this.returned;
            i = 0;
            while (i < this.returned) {
                this.rtBuffer[this.index++] = this.buffer[i];
                if (this.index == this.bufsize) {
                    this.index = 0;
                    Enumeration enume = this.listeners.elements();
                    while (enume.hasMoreElements()) {
                        AudioChainListener acl = (AudioChainListener)enume.nextElement();
                        acl.controlChange(this.rtBuffer, this.returned, this.finished);
                    }
                    this.block();
                }
                ++i;
            }
        }
    }
}

